/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;
import wardentools.worldgen.tree.ModFoliagePlacers;

public class WhitetreeFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<WhitetreeFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(whitetreeFoliagePlacerInstance -> WhitetreeFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)whitetreeFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)whitetreeFoliagePlacerInstance, WhitetreeFoliagePlacer::new));
    private final int height;

    public WhitetreeFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return ModFoliagePlacers.WHITETREE_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(@NotNull LevelSimulatedReader pLevel, @NotNull FoliagePlacer.FoliageSetter pBlockSetter, @NotNull RandomSource pRandom, @NotNull TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        double radius_base;
        boolean doubleTrunk = pAttachment.doubleTrunk();
        double radius_base_height = radius_base = (double)(pMaxFreeTreeHeight / 2 + 1);
        int start = Math.round(pMaxFreeTreeHeight / 3);
        this.placeFoliageDisk(pLevel, pBlockSetter, pRandom, pConfig, pMaxFreeTreeHeight, pAttachment, (int)Math.round(radius_base_height / 2.0), pOffset + start - 1, doubleTrunk);
        for (int i = start; i < pMaxFreeTreeHeight + (doubleTrunk ? 0 : 2); ++i) {
            radius_base_height = radius_base * (double)(pMaxFreeTreeHeight - i) / (double)pMaxFreeTreeHeight + 1.0;
            double radius = radius_base_height / (double)(1 + (i - start) % 3) / 1.5 + 1.0;
            this.placeFoliageDisk(pLevel, pBlockSetter, pRandom, pConfig, pMaxFreeTreeHeight, pAttachment, radius, pOffset + i, doubleTrunk);
        }
        if (doubleTrunk) {
            int x;
            for (x = -1; x < 3; ++x) {
                for (int z = -1; z < 3; ++z) {
                    if (x == -1 && z == -1 || x == 2 && z == 2 || x == -1 && z == 2 || x == 2 && z == -1) continue;
                    WhitetreeFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pAttachment.pos().offset(x, pMaxFreeTreeHeight, z));
                }
            }
            for (x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    WhitetreeFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pAttachment.pos().offset(x, pMaxFreeTreeHeight + 1, y));
                }
            }
        }
    }

    private void placeFoliageDisk(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, double pFoliageRadius, int pOffset, boolean doubleTrunk) {
        double radiusSquared = (pFoliageRadius + (double)(doubleTrunk ? 1 : 0)) * (pFoliageRadius + (double)(doubleTrunk ? 1 : 0));
        double centerXOffset = doubleTrunk ? -0.5 : 0.0;
        double centerZOffset = doubleTrunk ? -0.5 : 0.0;
        int x = -((int)Math.round(pFoliageRadius));
        while ((double)x <= pFoliageRadius + 2.0) {
            int z = -((int)Math.round(pFoliageRadius));
            while ((double)z <= pFoliageRadius + 2.0) {
                boolean cond;
                boolean bl = cond = ((double)x + centerXOffset) * ((double)x + centerXOffset) + ((double)z + centerZOffset) * ((double)z + centerZOffset) < radiusSquared;
                if (cond) {
                    BlockPos pos = pAttachment.pos().offset(x, pOffset, z);
                    WhitetreeFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
                }
                ++z;
            }
            ++x;
        }
    }

    public int foliageHeight(@NotNull RandomSource pRandom, int pHeight, @NotNull TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean shouldSkipLocation(@NotNull RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }
}

