/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.debug;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.simulation.Brick;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.simulation.WakeNode;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class WakeDebugRenderer {
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        WakeHandler wakeHandler = WakeHandler.getInstance().orElse(null);
        if (wakeHandler == null) {
            return;
        }
        if (((Boolean)WakesConfig.DEBUG.drawDebugBoxes.get()).booleanValue()) {
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = event.getLevelRenderer().renderBuffers.bufferSource();
            Vec3 cameraPos = event.getCamera().getPosition();
            for (WakeNode node : wakeHandler.getVisible(event.getFrustum(), WakeNode.class)) {
                DebugRenderer.renderFilledBox((PoseStack)poseStack, (MultiBufferSource)bufferSource, (AABB)node.toBox().move(cameraPos.reverse()), (float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f);
            }
            for (Brick brick : wakeHandler.getVisible(event.getFrustum(), Brick.class)) {
                Vec3 pos = brick.pos;
                AABB box = new AABB(pos.x, pos.y - 0.1111111044883728, pos.z, pos.x + (double)brick.dim, pos.y, pos.z + (double)brick.dim);
                float[] col = Color.getHSBColor(new Random(pos.hashCode()).nextFloat(), 1.0f, 1.0f).getRGBColorComponents(null);
                DebugRenderer.renderFilledBox((PoseStack)poseStack, (MultiBufferSource)bufferSource, (AABB)box.move(cameraPos.reverse()), (float)col[0], (float)col[1], (float)col[2], (float)0.5f);
            }
        }
    }
}

