/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.event;

import com.leclowndu93150.wakes.WakesClient;
import com.leclowndu93150.wakes.debug.WakesDebugInfo;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class WakeWorldTicker {
    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            WakesClient.areShadersEnabled = WakesClient.areShadersEnabled();
            WakesDebugInfo.reset();
            WakeHandler.getInstance((Level)clientLevel).ifPresent(WakeHandler::tick);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().level() instanceof ClientLevel) {
            WakeHandler.init(event.getEntity().level());
            ResourceKey fromDimension = event.getFrom();
            if (Minecraft.getInstance().level == null || !Minecraft.getInstance().level.dimension().equals(fromDimension)) {
                WakeHandler.killDimension((ResourceKey<Level>)fromDimension);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().level() instanceof ClientLevel) {
            WakeHandler.init(event.getEntity().level());
        }
    }
}

