/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.mixin;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.EffectSpawningRule;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.custom.SplashPlaneParticle;
import com.leclowndu93150.wakes.utils.WakesUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class WakeSpawnerMixin
implements ProducesWake {
    @Shadow
    private Vec3 position;
    @Shadow
    private Level level;
    @Unique
    private boolean onFluidSurface = false;
    @Unique
    private Vec3 prevPosOnSurface = null;
    @Unique
    private Vec3 numericalVelocity = Vec3.ZERO;
    @Unique
    private double horizontalNumericalVelocity = 0.0;
    @Unique
    private Float wakeHeight = null;
    @Unique
    private SplashPlaneParticle splashPlane;
    @Unique
    private boolean hasRecentlyTeleported = false;

    @Shadow
    public abstract String toString();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract boolean isInLiquid();

    @Shadow
    public abstract boolean isInWater();

    @Override
    public boolean wakes$onFluidSurface() {
        return this.onFluidSurface;
    }

    @Override
    public Vec3 wakes$getNumericalVelocity() {
        return this.numericalVelocity;
    }

    @Override
    public double wakes$getHorizontalVelocity() {
        return this.horizontalNumericalVelocity;
    }

    @Override
    public Vec3 wakes$getPrevPos() {
        return this.prevPosOnSurface;
    }

    @Override
    public void wakes$setPrevPos(Vec3 pos) {
        this.prevPosOnSurface = pos;
    }

    @Override
    public Float wakes$wakeHeight() {
        return this.wakeHeight;
    }

    @Override
    public void wakes$setWakeHeight(float h) {
        this.wakeHeight = Float.valueOf(h);
    }

    @Override
    public void wakes$setSplashPlane(SplashPlaneParticle particle) {
        this.splashPlane = particle;
    }

    @Override
    public void wakes$setRecentlyTeleported(boolean b) {
        this.hasRecentlyTeleported = b;
    }

    @Override
    public SplashPlaneParticle wakes$getSplashPlane() {
        return this.splashPlane;
    }

    @Unique
    private boolean onFluidSurface() {
        double hitboxMaxY = this.getBoundingBox().maxY;
        BlockPos blockPos = BlockPos.containing((double)this.getX(), (double)hitboxMaxY, (double)this.getZ());
        FluidState fluidState = this.level.getFluidState(blockPos);
        double fluidHeight = (float)blockPos.getY() + fluidState.getHeight((BlockGetter)this.level, blockPos);
        return this.isInWater() && hitboxMaxY > fluidHeight;
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        Vec3 vel;
        this.onFluidSurface = this.onFluidSurface();
        Entity thisEntity = (Entity)this;
        this.numericalVelocity = vel = this.calculateVelocity(thisEntity);
        this.horizontalNumericalVelocity = vel.horizontalDistance();
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue()) {
            return;
        }
        if (this.onFluidSurface && !this.hasRecentlyTeleported) {
            this.wakeHeight = Float.valueOf(WakesUtils.getFluidLevel(this.level, thisEntity));
            Vec3 currPos = new Vec3(thisEntity.getX(), (double)this.wakeHeight.floatValue(), thisEntity.getZ());
            this.spawnEffects(thisEntity);
            this.wakes$setPrevPos(currPos);
        } else {
            this.wakeHeight = null;
            this.prevPosOnSurface = null;
        }
        this.wakes$setRecentlyTeleported(false);
    }

    @Inject(at={@At(value="HEAD")}, method={"teleportTo(DDD)V"})
    private void onTeleportTo(double x, double y, double z, CallbackInfo ci) {
        Vec3 currentPos = this.position;
        Vec3 newPos = new Vec3(x, y, z);
        double distanceSq = currentPos.distanceToSqr(newPos);
        if (distanceSq > 400.0) {
            this.wakes$setRecentlyTeleported(true);
            this.wakes$setPrevPos(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"moveTo(DDDFF)V"})
    private void onMoveTo(double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        Vec3 currentPos = this.position;
        Vec3 newPos = new Vec3(x, y, z);
        if (currentPos.distanceToSqr(newPos) > 400.0) {
            this.wakes$setRecentlyTeleported(true);
            this.wakes$setPrevPos(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setPos(DDD)V"})
    private void onSetPos(double x, double y, double z, CallbackInfo ci) {
        Vec3 newPos;
        Vec3 currentPos;
        double distanceSq;
        if (this.position != null && (distanceSq = (currentPos = this.position).distanceToSqr(newPos = new Vec3(x, y, z))) > 100.0) {
            this.wakes$setRecentlyTeleported(true);
            this.wakes$setPrevPos(null);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"doWaterSplashEffect"})
    private void onSwimmingStart(CallbackInfo ci) {
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue()) {
            return;
        }
        Entity thisEntity = (Entity)this;
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            if (this.wakeHeight == null) {
                this.wakeHeight = Float.valueOf(WakesUtils.getFluidLevel(this.level, thisEntity));
            }
            WakesUtils.placeFallSplash((Entity)this);
        }
    }

    @Unique
    private void spawnEffects(Entity thisEntity) {
        EffectSpawningRule rule = WakesUtils.getEffectRuleFromSource(thisEntity);
        if (rule.simulateWakes) {
            WakesUtils.placeWakeTrail(thisEntity);
        }
        if (rule.renderPlanes && this.splashPlane == null && this.horizontalNumericalVelocity > 0.01) {
            WakesUtils.spawnSplashPlane(this.level, thisEntity);
        }
    }

    @Unique
    private Vec3 calculateVelocity(Entity thisEntity) {
        if (thisEntity instanceof LocalPlayer) {
            return thisEntity.getDeltaMovement();
        }
        return this.prevPosOnSurface == null ? Vec3.ZERO : this.position.subtract(this.prevPosOnSurface);
    }
}

