/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.particle.custom;

import com.leclowndu93150.wakes.particle.WithOwnerParticleType;
import com.leclowndu93150.wakes.simulation.WakeNode;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class SplashCloudParticle
extends TextureSheetParticle {
    Entity owner;
    final double offset;
    final boolean isFromPaddles;

    public SplashCloudParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.lifetime = (int)((double)WakeNode.maxAge * 1.5);
        this.setSprite(sprites.get(world.random));
        this.offset = velocityX;
        this.isFromPaddles = velocityX == 0.0;
        this.quadSize = this.isFromPaddles ? this.quadSize * 2.0f : 0.3f;
    }

    public void tick() {
        ++this.age;
        if (this.isFromPaddles) {
            if (this.age > this.lifetime) {
                this.remove();
                return;
            }
            this.alpha = 1.0f - (float)this.age / (float)this.lifetime;
            return;
        }
        if (this.age > this.lifetime / 3) {
            this.remove();
            return;
        }
        this.alpha = 1.0f - (float)this.age / ((float)this.lifetime / 3.0f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.level.getFluidState(new BlockPos((int)this.x, (int)this.y, (int)this.z)).is((Fluid)Fluids.WATER)) {
            this.yd = 0.1;
            this.xd *= 0.92;
            this.yd *= 0.92;
            this.zd *= 0.92;
        } else {
            this.yd -= 0.05;
            this.xd *= 0.95;
            this.yd *= 0.95;
            this.zd *= 0.95;
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.setPos(this.x, this.y, this.z);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            SplashCloudParticle cloud = new SplashCloudParticle(world, x, y, z, this.sprites, velocityX, velocityY, velocityZ);
            if (parameters instanceof WithOwnerParticleType) {
                WithOwnerParticleType type = (WithOwnerParticleType)parameters;
                cloud.owner = type.owner;
            }
            return cloud;
        }
    }
}

