/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.particle.custom;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.ModParticles;
import com.leclowndu93150.wakes.particle.WithOwnerParticleType;
import com.leclowndu93150.wakes.simulation.SimulationNode;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.utils.WakesUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class SplashPlaneParticle
extends Particle {
    public Entity owner;
    float yaw;
    float prevYaw;
    Vec3 direction = Vec3.ZERO;
    private final SimulationNode simulationNode = new SimulationNode.SplashPlaneSimulation();
    public long imgPtr = -1L;
    public int texRes;
    public boolean hasPopulatedPixels = false;
    public boolean isRenderReady = false;
    public float lerpedYaw = 0.0f;

    protected SplashPlaneParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.initTexture(WakeHandler.resolution.res);
        WakeHandler.getInstance((Level)world).ifPresent(wakeHandler -> wakeHandler.registerSplashPlane(this));
    }

    public void remove() {
        Entity entity = this.owner;
        if (entity instanceof ProducesWake) {
            ProducesWake wakeOwner = (ProducesWake)entity;
            wakeOwner.wakes$setSplashPlane(null);
        }
        this.owner = null;
        this.deallocTexture();
        super.remove();
    }

    public void tick() {
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue() || !WakesUtils.getEffectRuleFromSource((Entity)this.owner).renderPlanes) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.prevYaw = this.yaw;
        Entity entity = this.owner;
        if (entity instanceof ProducesWake) {
            ProducesWake wakeOwner = (ProducesWake)entity;
            if (this.owner.isRemoved() || !wakeOwner.wakes$onFluidSurface() || wakeOwner.wakes$getHorizontalVelocity() < 0.01) {
                this.remove();
            } else {
                this.aliveTick(wakeOwner);
            }
        } else {
            this.remove();
        }
    }

    private void aliveTick(ProducesWake wakeProducer) {
        Vec3 vel = this.owner.getDeltaMovement();
        this.yaw = this.owner instanceof Boat ? -this.owner.getYRot() : 90.0f - (float)(57.29577951308232 * Math.atan2(vel.z, vel.x));
        this.direction = Vec3.directionFromRotation((float)0.0f, (float)(-this.yaw));
        Vec3 planeOffset = this.direction.scale((double)this.owner.getBbWidth() + (Double)WakesConfig.APPEARANCE.splashPlaneOffset.get());
        Vec3 planePos = this.owner.position().add(planeOffset);
        this.setPos(planePos.x, wakeProducer.wakes$wakeHeight().floatValue(), planePos.z);
        if (vel.length() / (Double)WakesConfig.APPEARANCE.maxSplashPlaneVelocity.get() > (double)0.3f && ((Boolean)WakesConfig.APPEARANCE.spawnParticles.get()).booleanValue()) {
            Random random = new Random();
            Vec3 particleOffset = new Vec3(-this.direction.z, 0.0, this.direction.x).scale(random.nextDouble() * (double)this.owner.getBbWidth() / 4.0);
            Vec3 particlePos = this.owner.position().add(this.direction.scale((double)this.owner.getBbWidth() - 0.3));
            Vec3 particleVelocity = Vec3.directionFromRotation((float)((float)(45.0 * random.nextDouble())), (float)((float)((double)(-this.yaw) + 30.0 * (random.nextDouble() - 0.5)))).scale(1.5 * vel.length());
            this.level.addParticle((ParticleOptions)ModParticles.SPLASH_CLOUD.get(), particlePos.x + particleOffset.x, this.y, particlePos.z + particleOffset.z, particleVelocity.x, particleVelocity.y, particleVelocity.z);
            this.level.addParticle((ParticleOptions)ModParticles.SPLASH_CLOUD.get(), particlePos.x - particleOffset.x, this.y, particlePos.z - particleOffset.z, particleVelocity.x, particleVelocity.y, particleVelocity.z);
        }
        this.simulationNode.tick(Float.valueOf((float)wakeProducer.wakes$getHorizontalVelocity()), null, null, null, null);
        this.populatePixels();
    }

    public void initTexture(int res) {
        long size = 4L * (long)res * (long)res;
        this.imgPtr = this.imgPtr == -1L ? MemoryUtil.nmemAlloc((long)size) : MemoryUtil.nmemRealloc((long)this.imgPtr, (long)size);
        this.texRes = res;
        this.hasPopulatedPixels = false;
    }

    public void deallocTexture() {
        MemoryUtil.nmemFree((long)this.imgPtr);
    }

    public void populatePixels() {
        int fluidColor = BiomeColors.getAverageWaterColor((BlockAndTintGetter)this.level, (BlockPos)this.owner.blockPosition());
        int lightCoordinate = LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.owner.blockPosition());
        int lightCol = Minecraft.getInstance().gameRenderer.lightTexture().lightPixels.getPixelRGBA(LightTexture.block((int)lightCoordinate), LightTexture.sky((int)lightCoordinate));
        float opacity = ((Double)WakesConfig.APPEARANCE.wakeOpacity.get()).floatValue() * 0.9f;
        int res = WakeHandler.resolution.res;
        for (int r = 0; r < res; ++r) {
            for (int c = 0; c < res; ++c) {
                long pixelOffset = 4L * ((long)r * (long)res + (long)c);
                MemoryUtil.memPutInt((long)(this.imgPtr + pixelOffset), (int)this.simulationNode.getPixelColor(c, r, fluidColor, lightCol, opacity));
            }
        }
        this.hasPopulatedPixels = true;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        this.isRenderReady = false;
        if (this.removed) {
            return;
        }
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && !((Boolean)WakesConfig.APPEARANCE.firstPersonSplashPlane.get()).booleanValue() && this.owner instanceof LocalPlayer) {
            return;
        }
        float diff = this.yaw - this.prevYaw;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        this.lerpedYaw = (this.prevYaw + diff * tickDelta) % 360.0f;
        this.isRenderReady = true;
    }

    public void translateMatrix(RenderLevelStageEvent context, PoseStack matrices) {
        Vec3 cameraPos = context.getCamera().getPosition();
        float tickDelta = context.getPartialTick().getGameTimeDeltaPartialTick(true);
        float x = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - cameraPos.z());
        matrices.translate(x, y, z);
    }

    public Vec3 getPos() {
        return new Vec3(this.x, this.y, this.z);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            SplashPlaneParticle splashPlane = new SplashPlaneParticle(world, x, y, z);
            if (parameters instanceof WithOwnerParticleType) {
                WithOwnerParticleType type = (WithOwnerParticleType)parameters;
                splashPlane.owner = type.owner;
                splashPlane.yaw = splashPlane.prevYaw = type.owner.getYRot();
                ((ProducesWake)splashPlane.owner).wakes$setSplashPlane(splashPlane);
            }
            return splashPlane;
        }
    }
}

