/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.render;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.Resolution;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.custom.SplashPlaneParticle;
import com.leclowndu93150.wakes.render.WakeTexture;
import com.leclowndu93150.wakes.render.enums.RenderType;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.utils.DelaunayTriangulator;
import com.leclowndu93150.wakes.utils.NotEnoughPointsException;
import com.leclowndu93150.wakes.utils.Triangle2D;
import com.leclowndu93150.wakes.utils.Vector2D;
import com.leclowndu93150.wakes.utils.WakesUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SplashPlaneRenderer {
    private static ArrayList<Vector2D> points;
    private static List<Triangle2D> triangles;
    private static ArrayList<Vec3> vertices;
    private static ArrayList<Vec3> normals;
    public static Map<Resolution, WakeTexture> wakeTextures;
    private static final double SQRT_8;

    private static void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res, false), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res, false), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res, false));
    }

    public static void init() {
        NeoForge.EVENT_BUS.register(SplashPlaneRenderer.class);
    }

    public static void setup() {
        SplashPlaneRenderer.distributePoints();
        SplashPlaneRenderer.generateMesh();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (WakeHandler.getInstance().isEmpty()) {
            return;
        }
        WakeHandler wakeHandler = WakeHandler.getInstance().get();
        for (SplashPlaneParticle particle : wakeHandler.getVisible(event.getFrustum(), SplashPlaneParticle.class)) {
            if (!particle.isRenderReady) continue;
            SplashPlaneRenderer.render(particle.owner, particle, event, event.getPoseStack());
        }
    }

    public static <T extends Entity> void render(T entity, SplashPlaneParticle splashPlane, RenderLevelStageEvent context, PoseStack matrices) {
        if (wakeTextures == null) {
            SplashPlaneRenderer.initTextures();
        }
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue() || !WakesUtils.getEffectRuleFromSource(entity).renderPlanes) {
            return;
        }
        RenderSystem.setShader(RenderType.getProgram());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        matrices.pushPose();
        splashPlane.translateMatrix(context, matrices);
        matrices.mulPose(Axis.YP.rotationDegrees(splashPlane.lerpedYaw + 180.0f));
        float velocity = (float)Math.floor(((ProducesWake)entity).wakes$getHorizontalVelocity() * 20.0) / 20.0f;
        float progress = Math.min(1.0f, velocity / ((Double)WakesConfig.APPEARANCE.maxSplashPlaneVelocity.get()).floatValue());
        float scalar = (float)((Double)WakesConfig.APPEARANCE.splashPlaneScale.get() * Math.sqrt(entity.getBbWidth() * Math.max(1.0f, progress) + 1.0f) / 3.0);
        matrices.scale(scalar, scalar, scalar);
        Matrix4f matrix = matrices.last().pose();
        wakeTextures.get((Object)WakeHandler.resolution).loadTexture(splashPlane.imgPtr);
        SplashPlaneRenderer.renderSurface(matrix);
        matrices.popPose();
    }

    private static void renderSurface(Matrix4f matrix) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (int s = -1; s < 2; ++s) {
            if (s == 0) continue;
            for (int i = 0; i < vertices.size(); ++i) {
                Vec3 vertex = vertices.get(i);
                Vec3 normal = normals.get(i);
                buffer.addVertex(matrix, (float)((double)s * (vertex.x * (Double)WakesConfig.APPEARANCE.splashPlaneWidth.get() + (Double)WakesConfig.APPEARANCE.splashPlaneGap.get())), (float)(vertex.z * (Double)WakesConfig.APPEARANCE.splashPlaneHeight.get()), (float)(vertex.y * (Double)WakesConfig.APPEARANCE.splashPlaneDepth.get())).setUv((float)vertex.x, (float)vertex.y).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.enableCull();
    }

    private static double upperBound(double x) {
        return -2.0 * x * x + SQRT_8 * x;
    }

    private static double lowerBound(double x) {
        return (SQRT_8 - 2.0) * x * x;
    }

    private static double height(double x, double y) {
        return 4.0 * (x * (SQRT_8 - x) - y - x * x) / SQRT_8;
    }

    private static Vec3 normal(double x, double y) {
        double nx = SQRT_8 / (4.0 * (4.0 * x + y - SQRT_8));
        double ny = SQRT_8 / (4.0 * (2.0 * x * x - SQRT_8 + 1.0));
        return Vec3.directionFromRotation((float)((float)Math.tan(nx)), (float)((float)Math.tan(ny)));
    }

    private static void distributePoints() {
        int res = WakesConfig.APPEARANCE.splashPlaneResolution.getAsInt();
        points = new ArrayList();
        for (float i = 0.0f; i < (float)res; i += 1.0f) {
            double x = i / (float)(res - 1);
            double h = SplashPlaneRenderer.upperBound(x) - SplashPlaneRenderer.lowerBound(x);
            int n_points = (int)Math.max(1.0, Math.floor(h * (double)res));
            for (float j = 0.0f; j < (float)(n_points + 1); j += 1.0f) {
                float y = (float)((double)(j / (float)n_points) * h + SplashPlaneRenderer.lowerBound(x));
                points.add(new Vector2D(x, y));
            }
        }
    }

    private static void generateMesh() {
        vertices = new ArrayList();
        normals = new ArrayList();
        try {
            DelaunayTriangulator delaunay = new DelaunayTriangulator(points);
            delaunay.triangulate();
            triangles = delaunay.getTriangles();
        }
        catch (NotEnoughPointsException e) {
            e.printStackTrace();
        }
        for (Triangle2D tri : triangles) {
            for (Vector2D vec : new Vector2D[]{tri.a, tri.b, tri.c}) {
                double x = vec.x;
                double y = vec.y;
                vertices.add(new Vec3(x, y, SplashPlaneRenderer.height(x, y)));
                normals.add(SplashPlaneRenderer.normal(x, y));
            }
        }
    }

    static {
        wakeTextures = null;
        SQRT_8 = Math.sqrt(8.0);
    }
}

