/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.render;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.Resolution;
import com.leclowndu93150.wakes.debug.WakesDebugInfo;
import com.leclowndu93150.wakes.render.WakeTexture;
import com.leclowndu93150.wakes.simulation.Brick;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class WakeRenderer {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private static void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res, true), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res, true), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res, true));
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        WakeHandler wakeHandler;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (((Boolean)WakesConfig.GENERAL.disableMod.get()).booleanValue()) {
            WakesDebugInfo.quadsRendered = 0;
            return;
        }
        if (wakeTextures == null) {
            WakeRenderer.initTextures();
        }
        if ((wakeHandler = (WakeHandler)WakeHandler.getInstance().orElse(null)) == null || WakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(event.getFrustum(), Brick.class);
        Matrix4f matrix = event.getPoseStack().last().pose();
        RenderSystem.enableBlend();
        Minecraft.getInstance().gameRenderer.overlayTexture().setupOverlayColor();
        Resolution resolution = WakeHandler.resolution;
        int n = 0;
        long tRendering = System.nanoTime();
        for (Brick brick : bricks) {
            WakeRenderer.render(matrix, event.getCamera(), brick, wakeTextures.get((Object)resolution));
            ++n;
        }
        WakesDebugInfo.renderingTime.add(System.nanoTime() - tRendering);
        WakesDebugInfo.quadsRendered = n;
    }

    private static void render(Matrix4f matrix, Camera camera, Brick brick, WakeTexture texture) {
        if (!brick.hasPopulatedPixels) {
            return;
        }
        texture.loadTexture(brick.imgPtr);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Vector3f pos = brick.pos.add(camera.getPosition().reverse()).toVector3f().add(0.0f, 0.8888889f, 0.0f);
        buffer.addVertex(matrix, pos.x, pos.y, pos.z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, pos.x, pos.y, pos.z + (float)brick.dim).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(matrix, pos.x + (float)brick.dim, pos.y, pos.z + (float)brick.dim).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, pos.x + (float)brick.dim, pos.y, pos.z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f);
        RenderSystem.disableCull();
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.enableCull();
    }
}

