/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.render.enums;

import com.leclowndu93150.wakes.WakesClient;
import com.leclowndu93150.wakes.config.WakesConfig;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;

public enum RenderType {
    AUTO(null),
    GENERAL(GameRenderer::getPositionColorTexLightmapShader),
    CUSTOM(GameRenderer::getPositionTexColorShader),
    SOLID(GameRenderer::getRendertypeSolidShader),
    TRANSLUCENT(GameRenderer::getRendertypeTranslucentShader),
    CUTOUT(GameRenderer::getRendertypeCutoutShader),
    ENTITY_SOLID(GameRenderer::getRendertypeEntitySolidShader),
    ENTITY_TRANSLUCENT(GameRenderer::getRendertypeEntityTranslucentShader),
    ENTITY_TRANSLUCENT_CULL(GameRenderer::getRendertypeEntityTranslucentCullShader),
    ENTITY_CUTOUT(GameRenderer::getRendertypeEntityCutoutShader),
    ENTITY_CUTOUT_NO_CULL(GameRenderer::getRendertypeEntityCutoutNoCullShader),
    ENTITY_CUTOUT_NO_CULL_Z_OFFSET(GameRenderer::getRendertypeEntityCutoutNoCullZOffsetShader);

    public final Supplier<ShaderInstance> program;

    private RenderType(Supplier<ShaderInstance> program) {
        this.program = program;
    }

    public static Supplier<ShaderInstance> getProgram() {
        if (WakesConfig.DEBUG.renderType.get() == AUTO) {
            if (WakesClient.areShadersEnabled) {
                return RenderType.ENTITY_TRANSLUCENT_CULL.program;
            }
            return RenderType.CUSTOM.program;
        }
        return ((RenderType)((Object)WakesConfig.DEBUG.renderType.get())).program;
    }
}

