/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.simulation;

import com.leclowndu93150.wakes.simulation.Brick;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.AABB;

public class QuadTree {
    public static final int BRICK_WIDTH = 4;
    private static final int MAX_DEPTH = (int)(26.0 - Math.log(4.0) / Math.log(2.0));
    private static final int ROOT_X = (int)(-Math.pow(2.0, 25.0));
    private static final int ROOT_Z = (int)(-Math.pow(2.0, 25.0));
    private static final int ROOT_WIDTH = (int)Math.pow(2.0, 26.0);
    private final QuadTree ROOT;
    private List<QuadTree> children;
    private final DecentralizedBounds bounds;
    private final int depth;
    private Brick brick;
    public final float yLevel;

    public QuadTree(float y) {
        this(ROOT_X, y, ROOT_Z, ROOT_WIDTH, 0, null);
    }

    private QuadTree(int x, float y, int z, int width, int depth, QuadTree root) {
        this.bounds = new DecentralizedBounds(x, y, z, width);
        this.depth = depth;
        this.ROOT = root == null ? this : root;
        this.yLevel = y;
    }

    private boolean hasLeaf() {
        return this.depth == MAX_DEPTH && this.brick != null;
    }

    private void initLeaf() {
        if (this.depth >= MAX_DEPTH) {
            this.brick = new Brick(this.bounds.x, this.yLevel, this.bounds.z, this.bounds.width);
            this.ROOT.updateAdjacency(this);
        }
    }

    public void cleanupArea(int minX, int minZ, int maxX, int maxZ) {
        if (!this.bounds.intersectsArea(minX, minZ, maxX, maxZ)) {
            return;
        }
        if (this.hasLeaf() && this.brick != null) {
            if (this.bounds.x >= minX && this.bounds.x + this.bounds.width <= maxX && this.bounds.z >= minZ && this.bounds.z + this.bounds.width <= maxZ) {
                this.brick.deallocTexture();
                this.brick = null;
            }
            return;
        }
        if (this.children != null) {
            for (QuadTree tree : this.children) {
                tree.cleanupArea(minX, minZ, maxX, maxZ);
            }
        }
    }

    protected void updateAdjacency(QuadTree leaf) {
        if (this == leaf) {
            return;
        }
        if (!this.bounds.neighbors(leaf.bounds) && !this.bounds.intersects(leaf.bounds)) {
            return;
        }
        if (this.brick != null) {
            this.brick.updateAdjacency(leaf.brick);
            return;
        }
        if (this.children != null) {
            for (QuadTree tree : this.children) {
                tree.updateAdjacency(leaf);
            }
        }
    }

    public boolean tick(WakeHandler wakeHandler) {
        if (this.hasLeaf()) {
            return this.brick.tick(wakeHandler);
        }
        if (this.children == null) {
            return false;
        }
        int aliveChildren = 0;
        for (QuadTree tree : this.children) {
            if (!tree.tick(wakeHandler)) continue;
            ++aliveChildren;
        }
        if (aliveChildren == 0) {
            this.prune();
        }
        return aliveChildren > 0;
    }

    public boolean insert(WakeNode node) {
        if (!this.bounds.contains(node.x, node.z)) {
            return false;
        }
        if (this.depth == MAX_DEPTH) {
            if (this.brick == null) {
                this.initLeaf();
            }
            this.brick.insert(node);
            return true;
        }
        if (this.children == null) {
            this.subdivide();
        }
        for (QuadTree tree : this.children) {
            if (!tree.insert(node)) continue;
            return true;
        }
        return false;
    }

    public void recolorWakes() {
        if (this.hasLeaf()) {
            this.brick.populatePixels();
        }
        if (this.children == null) {
            return;
        }
        for (QuadTree tree : this.children) {
            tree.recolorWakes();
        }
    }

    public <T> void query(Frustum frustum, ArrayList<T> output, Class<T> type) {
        if (!frustum.isVisible(this.bounds.toBox((int)this.yLevel))) {
            return;
        }
        if (this.hasLeaf() && this.brick.occupied > 0) {
            if (type.equals(Brick.class)) {
                output.add(type.cast(this.brick));
            }
            if (type.equals(WakeNode.class)) {
                ArrayList<WakeNode> nodes = new ArrayList<WakeNode>();
                this.brick.query(frustum, nodes);
                for (WakeNode node : nodes) {
                    output.add(type.cast(node));
                }
            }
            return;
        }
        if (this.children == null) {
            return;
        }
        for (QuadTree tree : this.children) {
            tree.query(frustum, output, type);
        }
    }

    private void subdivide() {
        if (this.depth == MAX_DEPTH) {
            return;
        }
        int x = this.bounds.x;
        int z = this.bounds.z;
        int w = this.bounds.width >> 1;
        this.children = new ArrayList<QuadTree>();
        this.children.add(0, new QuadTree(x, this.yLevel, z, w, this.depth + 1, this.ROOT));
        this.children.add(1, new QuadTree(x + w, this.yLevel, z, w, this.depth + 1, this.ROOT));
        this.children.add(2, new QuadTree(x, this.yLevel, z + w, w, this.depth + 1, this.ROOT));
        this.children.add(3, new QuadTree(x + w, this.yLevel, z + w, w, this.depth + 1, this.ROOT));
    }

    public void prune() {
        if (this.children != null) {
            for (QuadTree tree : this.children) {
                tree.prune();
                if (!tree.hasLeaf()) continue;
                tree.brick.deallocTexture();
            }
            this.children.set(0, null);
            this.children.set(1, null);
            this.children.set(2, null);
            this.children.set(3, null);
        }
        this.children = null;
    }

    public record DecentralizedBounds(int x, float y, int z, int width) {
        public boolean contains(int x, int z) {
            return this.x <= x && x < this.x + this.width && this.z <= z && z < this.z + this.width;
        }

        public boolean intersects(DecentralizedBounds other) {
            return this.x <= other.x + other.width && this.x + this.width >= other.x && this.z <= other.z + other.width && this.z + this.width >= other.z;
        }

        public boolean intersectsArea(int minX, int minZ, int maxX, int maxZ) {
            return this.x <= maxX && this.x + this.width >= minX && this.z <= maxZ && this.z + this.width >= minZ;
        }

        public boolean neighbors(DecentralizedBounds other) {
            return this.x != other.x + other.width && this.x + this.width != other.x && this.z != other.z + other.width && this.z + this.width != other.z;
        }

        public AABB toBox(int y) {
            return new AABB((double)this.x, (double)y - 0.5, (double)this.z, (double)(this.x + this.width), (double)y + 0.5, (double)(this.z + this.width));
        }
    }
}

