/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.simulation;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.Resolution;
import com.leclowndu93150.wakes.particle.custom.SplashPlaneParticle;
import com.leclowndu93150.wakes.simulation.QuadTree;
import com.leclowndu93150.wakes.simulation.QueueSet;
import com.leclowndu93150.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class WakeHandler {
    private static final Map<ResourceKey<Level>, WakeHandler> INSTANCES = new HashMap<ResourceKey<Level>, WakeHandler>();
    public Level world;
    private QuadTree[] trees;
    private QueueSet<WakeNode>[] toBeInserted;
    private final int minY;
    private final int maxY;
    private ArrayList<SplashPlaneParticle> splashPlanes;
    public static Resolution resolution = (Resolution)((Object)WakesConfig.APPEARANCE.wakeResolution.get());
    public static boolean resolutionResetScheduled = false;

    private WakeHandler(Level world) {
        this.world = world;
        this.minY = world.getMinBuildHeight();
        this.maxY = world.getMaxBuildHeight();
        int worldHeight = this.maxY - this.minY;
        this.trees = new QuadTree[worldHeight];
        this.toBeInserted = new QueueSet[worldHeight];
        for (int i = 0; i < worldHeight; ++i) {
            this.toBeInserted[i] = new QueueSet();
        }
        this.splashPlanes = new ArrayList();
    }

    public static Optional<WakeHandler> getInstance() {
        if (Minecraft.getInstance().level == null) {
            return Optional.empty();
        }
        ResourceKey dimension = Minecraft.getInstance().level.dimension();
        return Optional.ofNullable(INSTANCES.get(dimension));
    }

    public static Optional<WakeHandler> getInstance(Level world) {
        if (world == null) {
            return Optional.empty();
        }
        ResourceKey dimension = world.dimension();
        return Optional.ofNullable(INSTANCES.get(dimension));
    }

    public static void init(Level world) {
        if (world != null) {
            ResourceKey dimension = world.dimension();
            INSTANCES.put((ResourceKey<Level>)dimension, new WakeHandler(world));
        }
    }

    public static void kill() {
        INSTANCES.clear();
    }

    public static void killDimension(ResourceKey<Level> dimension) {
        INSTANCES.remove(dimension);
    }

    public void tick() {
        int i;
        if (((Resolution)((Object)WakesConfig.APPEARANCE.wakeResolution.get())).res != WakeHandler.resolution.res) {
            WakeHandler.scheduleResolutionChange((Resolution)((Object)WakesConfig.APPEARANCE.wakeResolution.get()));
        }
        for (i = 0; i < this.maxY - this.minY; ++i) {
            QueueSet<WakeNode> pendingNodes = this.toBeInserted[i];
            if (resolutionResetScheduled) {
                if (pendingNodes == null) continue;
                pendingNodes.clear();
                continue;
            }
            QuadTree tree = this.trees[i];
            if (tree == null) continue;
            tree.tick(this);
            while (pendingNodes.peek() != null) {
                tree.insert((WakeNode)pendingNodes.poll());
            }
        }
        for (i = this.splashPlanes.size() - 1; i >= 0; --i) {
            if (this.splashPlanes.get(i).isAlive()) continue;
            this.splashPlanes.remove(i);
        }
        if (resolutionResetScheduled) {
            this.changeResolution();
        }
    }

    public void recolorWakes() {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QuadTree tree = this.trees[i];
            if (tree == null) continue;
            tree.recolorWakes();
        }
        for (SplashPlaneParticle splashPlane : this.splashPlanes) {
            if (splashPlane == null) continue;
            splashPlane.populatePixels();
        }
    }

    public void registerSplashPlane(SplashPlaneParticle splashPlane) {
        this.splashPlanes.add(splashPlane);
    }

    public void insert(WakeNode node) {
        if (resolutionResetScheduled) {
            return;
        }
        int i = this.getArrayIndex(node.y);
        if (i < 0) {
            return;
        }
        if (this.trees[i] == null) {
            this.trees[i] = new QuadTree(node.y);
        }
        if (node.validPos(this.world)) {
            this.toBeInserted[i].add(node);
        }
    }

    public <T> ArrayList<T> getVisible(Frustum frustum, Class<T> type) {
        ArrayList<T> visibleObjects = new ArrayList<T>();
        if (type.equals(SplashPlaneParticle.class)) {
            for (SplashPlaneParticle particle : this.splashPlanes) {
                if (!frustum.isVisible(particle.getBoundingBox())) continue;
                visibleObjects.add(type.cast((Object)particle));
            }
        } else {
            for (int i = 0; i < this.maxY - this.minY; ++i) {
                if (this.trees[i] == null) continue;
                this.trees[i].query(frustum, visibleObjects, type);
            }
        }
        return visibleObjects;
    }

    private int getArrayIndex(int y) {
        if (y < this.minY || y >= this.maxY) {
            return -1;
        }
        return y - this.minY;
    }

    public static void scheduleResolutionChange(Resolution newRes) {
        resolutionResetScheduled = true;
    }

    private void changeResolution() {
        this.reset();
        resolution = (Resolution)((Object)WakesConfig.APPEARANCE.wakeResolution.get());
        resolutionResetScheduled = false;
    }

    private void reset() {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QuadTree tree = this.trees[i];
            if (tree != null) {
                tree.prune();
            }
            this.toBeInserted[i].clear();
        }
    }

    public void cleanupChunk(int minX, int minZ, int maxX, int maxZ) {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QuadTree tree = this.trees[i];
            if (tree == null) continue;
            tree.cleanupArea(minX, minZ, maxX, maxZ);
        }
    }
}

