/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.wakes.utils;

import com.leclowndu93150.wakes.config.WakesConfig;
import com.leclowndu93150.wakes.config.enums.EffectSpawningRule;
import com.leclowndu93150.wakes.duck.ProducesWake;
import com.leclowndu93150.wakes.particle.ModParticles;
import com.leclowndu93150.wakes.particle.WithOwnerParticleType;
import com.leclowndu93150.wakes.simulation.WakeHandler;
import com.leclowndu93150.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WakesUtils {
    public static void placeFallSplash(Entity entity) {
        WakeHandler wakeHandler = WakeHandler.getInstance(entity.level()).orElse(null);
        if (wakeHandler == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.splashNodes(entity, (int)Math.floor(((ProducesWake)entity).wakes$wakeHeight().floatValue()))) {
            wakeHandler.insert(node);
        }
    }

    public static void spawnPaddleSplashCloudParticle(Level world, Boat boat) {
        for (int i = 0; i < 2; ++i) {
            double phase;
            if (!boat.getPaddleState(i) || !(0.19634954631328583 <= (phase = (double)boat.paddlePositions[i] % (Math.PI * 2))) || !(phase <= 1.178097277879715)) continue;
            Vec3 rot = boat.getViewVector(1.0f);
            double x = boat.getX() + (i == 1 ? -rot.z : rot.z);
            double z = boat.getZ() + (i == 1 ? rot.x : -rot.x);
            Vec3 pos = new Vec3(x, (double)((ProducesWake)boat).wakes$wakeHeight().floatValue(), z);
            world.addParticle((ParticleOptions)ModParticles.SPLASH_CLOUD.get(), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnSplashPlane(Level world, Entity owner) {
        WithOwnerParticleType wake = ModParticles.SPLASH_PLANE.get().withOwner(owner);
        Vec3 pos = owner.position();
        world.addParticle((ParticleOptions)wake, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
    }

    public static void placeWakeTrail(Entity entity) {
        Vec3 prevPos;
        WakeHandler wakeHandler = WakeHandler.getInstance(entity.level()).orElse(null);
        if (wakeHandler == null) {
            return;
        }
        ProducesWake producer = (ProducesWake)entity;
        double velocity = producer.wakes$getHorizontalVelocity();
        int y = (int)Math.floor(producer.wakes$wakeHeight().floatValue());
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            for (WakeNode node : WakeNode.Factory.rowingNodes(boat, y)) {
                wakeHandler.insert(node);
            }
            if (((Boolean)WakesConfig.APPEARANCE.spawnParticles.get()).booleanValue()) {
                WakesUtils.spawnPaddleSplashCloudParticle(entity.level(), boat);
            }
        }
        if ((prevPos = producer.wakes$getPrevPos()) == null) {
            return;
        }
        for (WakeNode node : WakeNode.Factory.thickNodeTrail(prevPos.x, prevPos.z, entity.getX(), entity.getZ(), y, ((Integer)WakesConfig.GENERAL.initialStrength.get()).intValue(), velocity, entity.getBbWidth())) {
            wakeHandler.insert(node);
        }
    }

    public static EffectSpawningRule getEffectRuleFromSource(Entity source) {
        if (source instanceof Boat) {
            Boat boat = (Boat)source;
            List passengers = boat.getPassengers();
            if (passengers.contains(Minecraft.getInstance().player)) {
                return (EffectSpawningRule)((Object)WakesConfig.GENERAL.boatSpawning.get());
            }
            if (passengers.stream().anyMatch(Entity::isAlwaysTicking)) {
                return ((EffectSpawningRule)((Object)WakesConfig.GENERAL.boatSpawning.get())).mask((EffectSpawningRule)((Object)WakesConfig.GENERAL.otherPlayersSpawning.get()));
            }
            return (EffectSpawningRule)((Object)WakesConfig.GENERAL.boatSpawning.get());
        }
        if (source instanceof Player) {
            Player player = (Player)source;
            if (player.isSpectator()) {
                return EffectSpawningRule.DISABLED;
            }
            if (player instanceof LocalPlayer) {
                return (EffectSpawningRule)((Object)WakesConfig.GENERAL.playerSpawning.get());
            }
            if (player instanceof RemotePlayer) {
                return (EffectSpawningRule)((Object)WakesConfig.GENERAL.otherPlayersSpawning.get());
            }
            return EffectSpawningRule.DISABLED;
        }
        if (source instanceof LivingEntity) {
            return (EffectSpawningRule)((Object)WakesConfig.GENERAL.mobSpawning.get());
        }
        if (source instanceof ItemEntity) {
            return (EffectSpawningRule)((Object)WakesConfig.GENERAL.itemSpawning.get());
        }
        return EffectSpawningRule.DISABLED;
    }

    public static void bresenhamLine(int x1, int y1, int x2, int y2, ArrayList<Long> points) {
        int dy = y2 - y1;
        int dx = x2 - x1;
        if (dx == 0) {
            if (y2 < y1) {
                int temp = y1;
                y1 = y2;
                y2 = temp;
            }
            for (int y = y1; y < y2 + 1; ++y) {
                points.add(WakesUtils.posAsLong(x1, y));
            }
        } else {
            float k = (float)dy / (float)dx;
            int adjust = k >= 0.0f ? 1 : -1;
            int offset = 0;
            if (k <= 1.0f && k >= -1.0f) {
                int delta = Math.abs(dy) * 2;
                int threshold = Math.abs(dx);
                int thresholdInc = Math.abs(dx) * 2;
                int y = y1;
                if (x2 < x1) {
                    int temp = x1;
                    x1 = x2;
                    x2 = temp;
                    y = y2;
                }
                for (int x = x1; x < x2 + 1; ++x) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    y += adjust;
                    threshold += thresholdInc;
                }
            } else {
                int delta = Math.abs(dx) * 2;
                int threshold = Math.abs(dy);
                int thresholdInc = Math.abs(dy) * 2;
                int x = x1;
                if (y2 < y1) {
                    int temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                for (int y = y1; y < y2 + 1; ++y) {
                    points.add(WakesUtils.posAsLong(x, y));
                    if ((offset += delta) < threshold) continue;
                    x += adjust;
                    threshold += thresholdInc;
                }
            }
        }
    }

    public static long posAsLong(int x, int y) {
        int xs = x >> 31 & 1;
        int ys = y >> 31 & 1;
        long pos = (long)(x &= Integer.MAX_VALUE) << 32 | (long)(y &= Integer.MAX_VALUE);
        pos ^= ((long)(-xs) ^ pos) & Long.MIN_VALUE;
        pos ^= ((long)(-ys) ^ pos) & 0x80000000L;
        return pos;
    }

    public static int[] longAsPos(long pos) {
        return new int[]{(int)(pos >> 32), (int)pos};
    }

    public static MutableComponent translatable(String ... subKeys) {
        StringBuilder translationKey = new StringBuilder("wakes");
        for (String s : subKeys) {
            translationKey.append(".").append(s);
        }
        return Component.translatable((String)translationKey.toString());
    }

    public static int[] abgrInt2rgbaArr(int n) {
        int[] arr = new int[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n2 = i;
                arr[n2] = arr[n2] | (n >> i * 8 + j & 1) << 7 - j;
            }
        }
        return arr;
    }

    public static int rgbaArr2abgrInt(int[] arr) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 8; ++j) {
                n |= (arr[i] >> j & 1) << i * 8 + j;
            }
        }
        return n;
    }

    public static float getFluidLevel(Level world, Entity entityInFluid) {
        AABB box = entityInFluid.getBoundingBox();
        return WakesUtils.getFluidLevel(world, Mth.floor((double)box.minX), Mth.ceil((double)box.maxX), Mth.floor((double)box.minY), Mth.ceil((double)box.maxY), Mth.floor((double)box.minZ), Mth.ceil((double)box.maxZ));
    }

    private static float getFluidLevel(Level world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        block0: for (int y = minY; y < maxY; ++y) {
            float f = 0.0f;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    blockPos.set(x, y, z);
                    FluidState fluidState = world.getFluidState((BlockPos)blockPos);
                    if (fluidState.isSource()) {
                        f = Math.max(f, fluidState.getHeight((BlockGetter)world, (BlockPos)blockPos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockPos.getY() + f;
        }
        return maxY + 1;
    }
}

