/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.dimension.MapContentType;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class AllMapConnectionData {
    private HashMap<String, String> map = new HashMap();

    public String createKey(MapDimensionInfo struc, BlockPos pos) {
        ChunkPos c = struc.structure.getStartChunkPos(pos);
        return struc.dimensionId.toString() + "-" + c.f_45578_ + "_" + c.f_45579_;
    }

    public Data getDataFromKey(String key) {
        try {
            MapDimensionInfo struc = MapDimensions.getInfo(new ResourceLocation(key.split("-")[0]));
            String cps = key.split("-")[1];
            int x = Integer.parseInt(cps.split("_")[0]);
            int z = Integer.parseInt(cps.split("_")[1]);
            if (struc == null || cps == null) {
                return null;
            }
            return new Data(struc, new ChunkPos(x, z));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void tryCreateConnection(MapDimensionInfo origin, BlockPos oPos, MapDimensionInfo side, BlockPos sPos) {
        if (origin == null || side == null) {
            return;
        }
        if (!origin.contentType.canSpawnSideContent) {
            return;
        }
        if (side.contentType != MapContentType.SIDE_CONTENT) {
            return;
        }
        String key = this.createKey(origin, oPos);
        String key2 = this.createKey(side, sPos);
        this.map.put(key2, key);
    }

    public Data getOriginalMap(Level world, BlockPos pos) {
        Data data;
        String key;
        MapDimensionInfo struc = MapDimensions.getInfo(world);
        if (struc != null && struc.contentType == MapContentType.SIDE_CONTENT && this.map.containsKey(key = this.createKey(struc, pos)) && (data = this.getDataFromKey(this.map.get(key))) != null) {
            return data;
        }
        return null;
    }

    public static class Data {
        public MapDimensionInfo struc;
        public ChunkPos cp;

        public Data(MapDimensionInfo struc, ChunkPos cp) {
            this.struc = struc;
            this.cp = cp;
        }
    }
}

