/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.main.ExileLog;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerCapabilities {
    static HashMap<String, Capability<? extends ICap>> caps = new HashMap();

    public static void register(Capability<? extends ICap> cap, ICap obj) {
        caps.put(obj.getCapIdForSyncing(), cap);
    }

    public static void register(Capability<? extends ICap> cap, String syncid) {
        caps.put(syncid, cap);
    }

    public static void saveAllOnDeath(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player current = event.getEntity();
        original.reviveCaps();
        caps.values().forEach(x -> {
            try {
                ICap data = (ICap)current.getCapability(x).orElse(null);
                ICap origcap = (ICap)original.getCapability(x).orElse(null);
                if (origcap != null) {
                    data.deserializeNBT((Tag)((CompoundTag)origcap.serializeNBT()));
                    data.syncToClient(current);
                } else {
                    ExileLog.get().log("couldn't get original player's " + x.getName() + " capability", new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        original.invalidateCaps();
    }

    public static void syncAllToClient(Player player) {
        try {
            caps.values().forEach(x -> ((ICap)player.getCapability(x).orElse(null)).syncToClient(player));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ICap get(Player player, String id) {
        if (caps.containsKey(id)) {
            Capability<? extends ICap> cap = caps.get(id);
            return (ICap)player.getCapability(cap).orElse(null);
        }
        return null;
    }
}

