/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.events;

import com.robertx22.library_of_exile.components.DelayedTeleportData;
import com.robertx22.library_of_exile.components.PlayerDataCapability;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.util.UNICODE;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ExileLibEvents {
    public static void init() {
        ApiForgeEvents.registerForgeEvent(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            Player player = event.getEntity();
            if (player.m_9236_().f_46443_) {
                return;
            }
            try {
                if (!JsonExileRegistry.NOT_LOADED_JSONS_MAP.isEmpty()) {
                    int count = 0;
                    Object hovertext = "";
                    for (Map.Entry<ExileRegistryType, Set<ResourceLocation>> entry : JsonExileRegistry.NOT_LOADED_JSONS_MAP.entrySet()) {
                        for (Object s : entry.getValue()) {
                            hovertext = (String)hovertext + entry.getKey().id + ": " + s.toString() + "\n";
                            ++count;
                        }
                    }
                    HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)hovertext));
                    player.m_213846_((Component)Component.m_237113_((String)("Datapack Error: " + count + " Jsons errored while loading.")).m_130948_(Style.f_131099_.m_131144_(hover)));
                }
                LinkedHashSet<String> modNames = new LinkedHashSet<String>();
                if (!JsonExileRegistry.INVALID_JSONS_MAP.isEmpty()) {
                    int count = 0;
                    Object hovertext = "";
                    for (Map.Entry<ExileRegistryType, Set<String>> entry : JsonExileRegistry.INVALID_JSONS_MAP.entrySet()) {
                        for (String s : entry.getValue()) {
                            hovertext = (String)hovertext + entry.getKey().id + ": " + s + "\n";
                            ++count;
                            modNames.add(entry.getKey().getModName());
                        }
                    }
                    HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)hovertext));
                    player.m_213846_((Component)Component.m_237113_((String)("[DATAPACK ERROR]: " + count + " Jsons were marked as wrong with automatic error checking. Datapacks of these mods are affected:")).m_130948_(Style.f_131099_.m_131144_(hoverEvent).m_131152_(new ChatFormatting[]{ChatFormatting.RED})));
                    for (String modName : modNames) {
                        player.m_213846_((Component)Component.m_237113_((String)(" - " + modName)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
                    }
                }
                if (!JsonExileRegistry.INVALID_JSONS_MAP.isEmpty() || !JsonExileRegistry.NOT_LOADED_JSONS_MAP.isEmpty()) {
                    player.m_213846_((Component)Component.m_237113_((String)"Check the log file for more info.").m_130940_(ChatFormatting.YELLOW));
                    player.m_213846_((Component)Component.m_237113_((String)"THIS MEANS YOUR DATAPACKS ARE LIKELY BROKEN AND MIGHT BUG IN-GAME UNLESS FIXED").m_130940_(ChatFormatting.LIGHT_PURPLE));
                    player.m_213846_((Component)Component.m_237113_((String)(UNICODE.STAR + " If you're playing a Modpack, updating these mods will result in errors. wait for the modpack to update.")).m_130940_(ChatFormatting.AQUA));
                    player.m_213846_((Component)Component.m_237113_((String)(UNICODE.STAR + " If you made the datapacks yourself, use the Info from the log file to help you fix the jsons.")).m_130940_(ChatFormatting.AQUA));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ApiForgeEvents.registerForgeEvent(TickEvent.PlayerTickEvent.class, event -> {
            Player p = event.player;
            if (p.m_9236_().f_46443_ || event.phase != TickEvent.Phase.END) {
                return;
            }
            if (!p.m_6084_() || p.f_19797_ < 10) {
                return;
            }
            try {
                DelayedTeleportData delayed;
                PlayerDataCapability cap = PlayerDataCapability.get(p);
                if (cap != null && (delayed = PlayerDataCapability.get((Player)p).delayedTeleportData) != null && !delayed.command.isEmpty() && delayed.ticks-- < 1) {
                    delayed.teleport(p);
                }
            }
            catch (Exception e) {
                PlayerDataCapability.get((Player)p).delayedTeleportData = null;
                e.printStackTrace();
            }
        });
    }
}

