/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.localization;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ExileTranslation {
    public String unformattedKey;
    public String key;
    public String locname;

    public ExileTranslation(String key, String locname) {
        this.unformattedKey = key;
        this.key = ExileTranslation.getFormatedKeyForLangFile(key);
        this.locname = locname;
    }

    public static ExileTranslation registry(ExileRegistry<?> reg, String locname) {
        return new ExileTranslation(reg.getExileRegistryType().modid + "." + reg.getExileRegistryType().idWithoutModid + "." + reg.GUID(), locname);
    }

    public static ExileTranslation of(String id, String locname) {
        return new ExileTranslation(id, locname);
    }

    public static ExileTranslation item(Item item, String locname) {
        String id = VanillaUTIL.REGISTRY.items().getKey(item).toString();
        return new ExileTranslation("item." + id, locname);
    }

    public static ExileTranslation block(Block item, String locname) {
        String id = VanillaUTIL.REGISTRY.blocks().getKey(item).toString();
        return new ExileTranslation("block." + id, locname);
    }

    public static ExileTranslation mobEffect(MobEffect item, String locname) {
        String id = BuiltInRegistries.f_256974_.m_7981_((Object)item).toString();
        return new ExileTranslation("block." + id, locname);
    }

    public static String getFormatedKeyForLangFile(String s) {
        return s.replaceAll(" ", "_").toLowerCase(Locale.ROOT).replaceAll("/", ".").replaceAll(":", ".");
    }

    public MutableComponent getTranslatedName(Object ... objects) {
        return Component.m_237110_((String)this.key, (Object[])objects);
    }
}

