/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets;

import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.components.PlayerCapabilities;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SyncPlayerCapToClient
extends MyPacket<SyncPlayerCapToClient> {
    public String capid;
    public CompoundTag nbt;

    public SyncPlayerCapToClient() {
    }

    public SyncPlayerCapToClient(Player player, String capid) {
        this.nbt = (CompoundTag)PlayerCapabilities.get(player, capid).serializeNBT();
        this.capid = capid;
    }

    @Override
    public ResourceLocation getIdentifier() {
        return new ResourceLocation("library_of_exile", "syncplayercap");
    }

    @Override
    public void loadFromData(FriendlyByteBuf tag) {
        this.capid = tag.m_130136_(100);
        this.nbt = tag.m_130260_();
    }

    @Override
    public void saveToData(FriendlyByteBuf tag) {
        tag.m_130072_(this.capid, 100);
        tag.m_130079_(this.nbt);
    }

    @Override
    public void onReceived(ExilePacketContext ctx) {
        try {
            ICap cap;
            Player player = ctx.getPlayer();
            if (player.m_9236_().f_46443_ && (cap = PlayerCapabilities.get(player, this.capid)) != null) {
                cap.deserializeNBT((Tag)this.nbt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public MyPacket<SyncPlayerCapToClient> newInstance() {
        return new SyncPlayerCapToClient();
    }
}

