/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.helpers;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.deferred.RegObj;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.helpers.ExileKey;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolderSection;
import com.robertx22.library_of_exile.registry.register_info.ModRequiredRegisterInfo;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public abstract class ExileKeyHolder<T extends ExileRegistry<T>> {
    public List<ExileKeyHolderSection> sections = new ArrayList<ExileKeyHolderSection>();
    public ModRequiredRegisterInfo modRegisterInfo;
    private ItemIdProvider itemIdProvider = new ItemIdProvider(null);
    private ItemCreator<T> itemCreator = new ItemCreator(null);
    public HashMap<String, ExileKey<T, ?>> all = new HashMap();
    public Function<ItemRegistratorData, RegObj<Item>> itemRegistrator = null;
    private List<Supplier<ExileKeyHolder<?>>> deps = new ArrayList();
    private boolean initEntries = false;
    private boolean initItems = false;

    public ExileKeyHolder(ModRequiredRegisterInfo modRegisterInfo) {
        this.modRegisterInfo = modRegisterInfo;
    }

    public ExileKeyHolder<T> dependsOn(Supplier<ExileKeyHolder<?>> dep) {
        return this;
    }

    public boolean hasItemProvider() {
        return this.itemIdProvider.itemIdMaker != null;
    }

    public ExileKeyHolder<T> itemIds(ItemIdProvider item) {
        this.itemIdProvider = item;
        return this;
    }

    public ExileKeyHolder<T> createItems(ItemCreator item, Function<ItemRegistratorData, RegObj<Item>> registrator) {
        this.itemCreator = item;
        this.itemRegistrator = registrator;
        return this;
    }

    public ResourceLocation getItemId(String id) {
        Preconditions.checkNotNull(this.itemIdProvider.itemIdMaker);
        return this.itemIdProvider.itemIdMaker.apply(id);
    }

    public Item getItem(ResourceLocation id) {
        return VanillaUTIL.REGISTRY.items().get(id);
    }

    public Item getItem(ExileKey<T, ?> key) {
        ResourceLocation id = this.getItemId(key.GUID());
        return this.getItem(id);
    }

    public abstract void loadClass();

    public void init() {
        this.prepareInit();
        this.initItems();
        this.initExileDBEntries();
    }

    private void initExileDBEntries() {
        for (ExileKey<T, ?> key : this.all.values()) {
            key.register();
        }
        this.initEntries = true;
    }

    private void prepareInit() {
        for (Supplier<ExileKeyHolder<?>> dep : this.deps) {
            if (dep.get() == null) {
                throw new RuntimeException("Dependency is null");
            }
            if (dep.get().initEntries) continue;
            throw new RuntimeException("Dependency wasn't initialized");
        }
        this.loadClass();
        for (ExileKeyHolderSection section : this.sections) {
            section.init();
        }
    }

    private void initItems() {
        if (!this.initItems) {
            this.initItems = true;
            if (this.itemCreator.maker != null && this.itemIdProvider.itemIdMaker != null) {
                for (ExileKey<T, ?> key : this.all.values()) {
                    if (key.isCancelItemCreation()) continue;
                    ResourceLocation id = this.getItemId(key.GUID());
                    ItemRegistratorData data = new ItemRegistratorData(id.m_135815_(), () -> this.itemCreator.maker.apply(key));
                    key.item = this.itemRegistrator.apply(data);
                }
            }
        }
    }

    public static class ItemIdProvider {
        Function<String, ResourceLocation> itemIdMaker = null;

        public ItemIdProvider(Function<String, ResourceLocation> itemIdMaker) {
            this.itemIdMaker = itemIdMaker;
        }
    }

    public static class ItemCreator<T extends ExileRegistry<T>> {
        Function<ExileKey<T, ?>, Item> maker = null;

        public ItemCreator(Function<ExileKey<T, ?>, Item> itemIdMaker) {
            this.maker = itemIdMaker;
        }
    }

    public record ItemRegistratorData(String itemID, Supplier<Item> item) {
    }
}

