/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.helpers;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.ExileRegistryEvent;
import com.robertx22.library_of_exile.registry.ExileRegistryEventClass;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolder;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraftforge.eventbus.api.IEventBus;

public abstract class OrderedModConstructor {
    String modid;
    static Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(final OrderedModConstructor c, IEventBus modbus) {
        try {
            lock.lock();
            c.registerDeferredContainers(modbus);
            c.registerDeferredEntries();
            c.registerDatabases();
            final boolean[] done = new boolean[]{false};
            ExileEvents.EXILE_REGISTRY_GATHER.register(new EventConsumer<ExileRegistryEvent>(){

                @Override
                public void accept(ExileRegistryEvent e) {
                    if (!done[0]) {
                        c.registerDatabaseEntries();
                        done[0] = true;
                    }
                }
            });
            for (ExileRegistryEventClass event : c.getRegisterEvents()) {
                event.register();
            }
            for (ExileKeyHolder holder : c.getAllKeyHolders()) {
                holder.init();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public OrderedModConstructor(String modid) {
        this.modid = modid;
        ExileLog.get().log("Mod Constructor Registered : " + modid, new Object[0]);
    }

    public abstract List<ExileRegistryEventClass> getRegisterEvents();

    public abstract List<ExileKeyHolder> getAllKeyHolders();

    public abstract void registerDeferredContainers(IEventBus var1);

    public abstract void registerDeferredEntries();

    public abstract void registerDatabases();

    public abstract void registerDatabaseEntries();
}

