/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.database.dungeon;

import com.robertx22.dungeon_realm.database.DungeonDatabase;
import com.robertx22.dungeon_realm.room_adders.BaseRoomAdder;
import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonData;
import com.robertx22.library_of_exile.dimension.structure.dungeon.IDungeon;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.ITranslated;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.tags.ExileTagRequirement;

public class Dungeon
implements IAutoGson<Dungeon>,
JsonExileRegistry<Dungeon>,
ITranslated,
IDungeon {
    public static Dungeon SERIALIZER = new Dungeon();
    public String id = "";
    public int weight = 1000;
    public String author = "";
    public transient String name = "";
    public transient String modid = "";
    public DungeonData data = new DungeonData();

    public boolean isRegistryEntryValid() {
        return this.data.checkValidity((ExileRegistry)this);
    }

    public ExileRegistryType getExileRegistryType() {
        return DungeonDatabase.DUNGEON;
    }

    public Class<Dungeon> getClassForSerialization() {
        return Dungeon.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return this.weight;
    }

    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of((String)this.modid).name(ExileTranslation.registry((ExileRegistry)this, (String)this.name));
    }

    public DungeonData getDungeonData() {
        return this.data;
    }

    public static class Builder {
        Dungeon dungeon = new Dungeon();

        public static Builder of(String id, String name, BaseRoomAdder adder, String modid) {
            Builder b = new Builder();
            b.dungeon.id = id;
            b.dungeon.name = name;
            b.dungeon.modid = modid;
            b.dungeon.data.folder = id;
            adder.addRoomsToDungeon(b.dungeon);
            return b;
        }

        public Builder author(String author) {
            this.dungeon.author = author;
            return this;
        }

        public Builder weight(int w) {
            this.dungeon.weight = w;
            return this;
        }

        public Builder tags(ExileTagRequirement<MobList> w) {
            this.dungeon.data.mob_list_tag_check = w;
            return this;
        }

        public Dungeon getDungeon() {
            return this.dungeon;
        }

        public Dungeon build() {
            return this.dungeon;
        }
    }
}

