/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.structure;

import com.google.gson.JsonSyntaxException;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.structure.DungeonMapData;
import com.robertx22.dungeon_realm.structure.DungeonWorldData;
import com.robertx22.library_of_exile.dimension.MapDataFinder;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.utils.LoadSave;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DungeonMapCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public Level world;
    public static final ResourceLocation RESOURCE = new ResourceLocation(DungeonMain.MODID, "world_data");
    public static Capability<DungeonMapCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<DungeonMapCapability>(){});
    final transient LazyOptional<DungeonMapCapability> supp = LazyOptional.of(() -> this);
    public DungeonWorldData data = new DungeonWorldData();
    public static MapDataFinder<DungeonMapData> DATA_GETTER = new MapDataFinder<DungeonMapData>(){

        public DungeonMapData getData(MapDataFinder.Pos pos) {
            return (DungeonMapData)DungeonMapCapability.get((Level)pos.level).data.data.getData(this.getInfo().structure, pos.pos);
        }

        public MapDimensionInfo getInfo() {
            return DungeonMain.MAP;
        }
    };

    public DungeonMapCapability(Level world) {
        this.world = world;
    }

    public static DungeonMapCapability get(Level entity) {
        return (DungeonMapCapability)entity.m_7654_().m_129783_().getCapability(INSTANCE).orElse((Object)new DungeonMapCapability(entity));
    }

    public static DungeonMapCapability getFromServer() {
        return DungeonMapCapability.get((Level)ServerLifecycleHooks.getCurrentServer().m_129783_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        try {
            LoadSave.Save((Object)this.data, (CompoundTag)nbt, (String)"data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        try {
            this.data = (DungeonWorldData)LoadSave.loadOrBlank(DungeonWorldData.class, (Object)new DungeonWorldData(), (CompoundTag)nbt, (String)"data", (Object)new DungeonWorldData());
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }
}

