/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.tooltip;

import com.robertx22.dungeon_realm.item.DungeonItemMapData;
import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.main.DungeonWords;
import com.robertx22.library_of_exile.tooltip.TooltipBuilder;
import com.robertx22.library_of_exile.tooltip.TooltipItem;
import com.robertx22.library_of_exile.tooltip.order.ExileTooltipPart;
import com.robertx22.library_of_exile.tooltip.order.TooltipOrder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MapTooltip
extends TooltipItem {
    public static MapTooltip DEFAULT = new MapTooltip(ItemStack.f_41583_, null);
    public ItemStack stack;
    public DungeonItemMapData data;

    public MapTooltip(ItemStack stack, DungeonItemMapData data) {
        super("dungeon_map");
        this.stack = stack;
        this.data = data;
    }

    public static List<Component> getTooltip(ItemStack stack) {
        DungeonItemMapData map = (DungeonItemMapData)DungeonItemNbt.DUNGEON_MAP.loadFrom(stack);
        if (map == null) {
            return Arrays.asList(new Component[0]);
        }
        TooltipBuilder b = new TooltipBuilder((TooltipItem)new MapTooltip(stack, map));
        if (map.uber) {
            b.add(x -> new ExileTooltipPart(TooltipOrder.LATE, (Component[])new MutableComponent[]{MapTooltip.MapHasUber()}));
        }
        b.add(x -> new ExileTooltipPart(TooltipOrder.LAST, Arrays.asList(DungeonWords.MAP_ITEM_DESC.get(new Object[0]).m_130940_(ChatFormatting.BLUE), DungeonWords.MAP_ITEM_USE_INFO.get(new Object[0]).m_130940_(ChatFormatting.BLUE))));
        b.add(x -> new ExileTooltipPart(TooltipOrder.FIRST, (Component[])new MutableComponent[]{MapTooltip.MapLayoutName(map.dungeon)}));
        return b.build();
    }

    @NotNull
    public static MutableComponent MapHasUber() {
        return DungeonWords.MAP_HAS_UBER_ARENA.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    }

    @NotNull
    public static MutableComponent MapLayoutName(String dungeon) {
        return DungeonWords.MAP_LAYOUT.get(Component.m_237115_((String)DungeonWords.MapGUID(dungeon)).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY);
    }
}

