/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.client;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.mrwilfis.treasures_of_the_dead.client.ClientUtilities;
import net.mrwilfis.treasures_of_the_dead.item.custom.ModGunItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="treasures_of_the_dead", dist={Dist.CLIENT})
public class ClientSetup {
    public ClientSetup(IEventBus bus) {
        bus.addListener(this::setup);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, this::renderHand);
        NeoForge.EVENT_BUS.addListener(this::renderPlayer);
    }

    public void setup(FMLClientSetupEvent event) {
        ClientUtilities.registerItemProperties();
    }

    public void renderHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.isEmpty() && stack.getItem() instanceof ModGunItem) {
            Minecraft mc = Minecraft.getInstance();
            ClientUtilities.renderGunInHand(mc.getEntityRenderDispatcher().getItemInHandRenderer(), (AbstractClientPlayer)mc.player, event.getHand(), event.getPartialTick(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress(), stack, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }
    }

    public void renderPlayer(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        Player player;
        LivingEntity livingEntity;
        block6: {
            block5: {
                livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                livingEntity = event.getRenderer().getModel();
                if (livingEntity instanceof PlayerModel) break block6;
            }
            return;
        }
        PlayerModel model = (PlayerModel)livingEntity;
        Optional<HumanoidModel.ArmPose> mainHandPose = ClientUtilities.getArmPose(player, InteractionHand.MAIN_HAND);
        Optional<HumanoidModel.ArmPose> offhandPose = ClientUtilities.getArmPose(player, InteractionHand.OFF_HAND);
        if (player.getMainArm() == HumanoidArm.RIGHT) {
            model.rightArmPose = mainHandPose.isPresent() ? mainHandPose.get() : model.rightArmPose;
            model.leftArmPose = offhandPose.isPresent() ? offhandPose.get() : model.leftArmPose;
        } else {
            model.rightArmPose = offhandPose.isPresent() ? offhandPose.get() : model.rightArmPose;
            model.leftArmPose = mainHandPose.isPresent() ? mainHandPose.get() : model.leftArmPose;
        }
    }
}

