/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import net.mrwilfis.treasures_of_the_dead.item.custom.ModGunItem;

public class ClientUtilities {
    public static boolean disableMainHandEquipAnimation;
    public static boolean disableOffhandEquipAnimation;

    public static void registerItemProperties() {
        ClampedItemPropertyFunction predicate = (stack, level, player, seed) -> ModGunItem.getCharged(stack) ? 1.0f : 0.0f;
        ResourceLocation location = Treasures_of_the_dead.resource("loaded");
        ItemProperties.register((Item)((Item)ModItems.PISTOL.get()), (ResourceLocation)location, (ItemPropertyFunction)predicate);
    }

    public static Optional<HumanoidModel.ArmPose> getArmPose(Player player, InteractionHand hand) {
        ModGunItem gun;
        Item item;
        ItemStack stack = player.getItemInHand(hand);
        if (!player.swinging && !stack.isEmpty() && (item = stack.getItem()) instanceof ModGunItem && (gun = (ModGunItem)item).canUseFrom((LivingEntity)player, hand) && ModGunItem.getCharged(stack)) {
            return Optional.of(HumanoidModel.ArmPose.CROSSBOW_HOLD);
        }
        return Optional.empty();
    }

    public static void renderGunInHand(ItemInHandRenderer renderer, AbstractClientPlayer player, InteractionHand hand, float dt, float pitch, float swingProgress, float equipProgress, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        HumanoidArm arm = hand == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
        boolean isRightHand = arm == HumanoidArm.RIGHT;
        float sign = isRightHand ? 1.0f : -1.0f;
        ModGunItem gun = (ModGunItem)stack.getItem();
        if (!gun.canUseFrom((LivingEntity)player, hand)) {
            poseStack.pushPose();
            poseStack.translate((double)sign * 0.5, -0.5 - 0.6 * (double)equipProgress, -0.7);
            poseStack.mulPose(Axis.XP.rotationDegrees(70.0f));
            renderer.renderItem((LivingEntity)player, stack, isRightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !isRightHand, poseStack, bufferSource, light);
            poseStack.popPose();
            return;
        }
        ItemStack activeStack = ModGunItem.getActiveStack(hand);
        if (stack == activeStack) {
            ClientUtilities.setEquipAnimationDisabled(hand, true);
        } else if (activeStack != null && activeStack.getItem() != gun) {
            ClientUtilities.setEquipAnimationDisabled(hand, false);
        }
        poseStack.pushPose();
        poseStack.translate((double)sign * 0.15 * 4.0, -0.5, -0.7);
        if (swingProgress > 0.0f) {
            float swingSharp = Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
            float swingNormal = Mth.sin((float)(swingProgress * (float)Math.PI));
            poseStack.translate((double)sign * 0.05 * (double)(1.0f - swingNormal) * 4.0, 0.05 * (double)(1.0f - swingNormal) * 2.0, 0.05 - 0.4 * (double)swingSharp * 2.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f + sign * 20.0f * (1.0f - swingSharp)));
        } else if (player.isUsingItem() && player.getUsedItemHand() == hand) {
            poseStack.translate(0.0, -0.3, 0.05);
            if (player.getTicksUsingItem() <= gun.getUseDuration(stack, (LivingEntity)player)) {
                poseStack.mulPose(Axis.XP.rotationDegrees(60.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(sign * 10.0f));
                if (player.getTicksUsingItem() % 8 == 0) {
                    poseStack.translate(0.0, -0.1, 0.0);
                }
            }
        } else if (ClientUtilities.isEquipAnimationDisabled(hand)) {
            if (equipProgress == 0.0f) {
                ClientUtilities.setEquipAnimationDisabled(hand, false);
                ModGunItem.setActiveStack(hand, null);
            }
        } else {
            poseStack.translate(0.0, -0.6 * (double)equipProgress, 0.0);
        }
        renderer.renderItem((LivingEntity)player, stack, isRightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !isRightHand, poseStack, bufferSource, light);
        poseStack.popPose();
    }

    public static boolean isEquipAnimationDisabled(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return disableMainHandEquipAnimation;
        }
        return disableOffhandEquipAnimation;
    }

    public static void setEquipAnimationDisabled(InteractionHand hand, boolean disabled) {
        if (hand == InteractionHand.MAIN_HAND) {
            disableMainHandEquipAnimation = disabled;
        } else {
            disableOffhandEquipAnimation = disabled;
        }
    }
}

