/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.mrwilfis.treasures_of_the_dead.Treasures_of_the_dead;
import net.mrwilfis.treasures_of_the_dead.entity.client.CaptainSkeletonModel;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainSkeletonVariant;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class CaptainSkeletonRenderer
extends GeoEntityRenderer<CaptainSkeletonEntity> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_boot";
    private static final String RIGHT_BOOT = "right_boot";
    private static final String LEFT_ARMOR_LEG = "left_armor_leg";
    private static final String RIGHT_ARMOR_LEG = "right_armor_leg";
    private static final String CHESTPLATE = "chestplate";
    private static final String CHEST_LEGGINGS = "chest_leggings";
    private static final String HELMET = "helmet";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_SLEEVE = "left_sleeve";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    public static final Map<CaptainSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(CaptainSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(CaptainSkeletonVariant.DEFAULT, Treasures_of_the_dead.resource("textures/entity/pirate_skeleton1.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR1, Treasures_of_the_dead.resource("textures/entity/pirate_skeleton2.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR2, Treasures_of_the_dead.resource("textures/entity/pirate_skeleton3.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR3, Treasures_of_the_dead.resource("textures/entity/pirate_skeleton4.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR4, Treasures_of_the_dead.resource("textures/entity/pirate_skeleton5.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR5, Treasures_of_the_dead.resource("textures/entity/pirate_skeleton6.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR6, Treasures_of_the_dead.resource("textures/entity/captain_skeleton1.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR7, Treasures_of_the_dead.resource("textures/entity/captain_skeleton2.png"));
    });

    public CaptainSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CaptainSkeletonModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<CaptainSkeletonEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_BOOT, CaptainSkeletonRenderer.RIGHT_BOOT -> this.bootsStack;
                    case CaptainSkeletonRenderer.LEFT_ARMOR_LEG, CaptainSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainSkeletonRenderer.CHEST_LEGGINGS -> this.leggingsStack;
                    case CaptainSkeletonRenderer.CHESTPLATE, CaptainSkeletonRenderer.RIGHT_SLEEVE, CaptainSkeletonRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case CaptainSkeletonRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_BOOT, CaptainSkeletonRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case CaptainSkeletonRenderer.LEFT_ARMOR_LEG, CaptainSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainSkeletonRenderer.CHEST_LEGGINGS -> EquipmentSlot.LEGS;
                    case CaptainSkeletonRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case CaptainSkeletonRenderer.LEFT_SLEEVE -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case CaptainSkeletonRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case CaptainSkeletonRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, CaptainSkeletonEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_BOOT, CaptainSkeletonRenderer.LEFT_ARMOR_LEG -> baseModel.leftLeg;
                    case CaptainSkeletonRenderer.RIGHT_BOOT, CaptainSkeletonRenderer.RIGHT_ARMOR_LEG -> baseModel.rightLeg;
                    case CaptainSkeletonRenderer.RIGHT_SLEEVE -> baseModel.rightArm;
                    case CaptainSkeletonRenderer.LEFT_SLEEVE -> baseModel.leftArm;
                    case CaptainSkeletonRenderer.CHESTPLATE, CaptainSkeletonRenderer.CHEST_LEGGINGS -> baseModel.body;
                    case CaptainSkeletonRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<CaptainSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield CaptainSkeletonRenderer.this.mainHandItem;
                        }
                        yield CaptainSkeletonRenderer.this.offhandItem;
                    }
                    case CaptainSkeletonRenderer.RIGHT_HAND -> {
                        if (animatable.isLeftHanded()) {
                            yield CaptainSkeletonRenderer.this.offhandItem;
                        }
                        yield CaptainSkeletonRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_HAND, CaptainSkeletonRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, CaptainSkeletonEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == CaptainSkeletonRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, -0.25);
                    }
                } else if (stack == CaptainSkeletonRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(0.0, 0.125, 0.25);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(CaptainSkeletonEntity instance) {
        return LOCATION_BY_VARIANT.get((Object)instance.getCaptainVariant());
    }

    public void preRender(PoseStack poseStack, CaptainSkeletonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public void render(CaptainSkeletonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

