/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.particle.ModParticles;
import net.mrwilfis.treasures_of_the_dead.sound.ModSounds;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class BlunderBombEntity
extends ThrowableProjectile
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation FLY = RawAnimation.begin().then("animation.blunder_bomb.fly", Animation.LoopType.LOOP);
    private final float MAX_DAMAGE = 15.0f;
    private final float MIN_DISTANCE = 5.0f;
    private final float ON_HIT_ENTITY_DAMAGE = 4.0f;

    public BlunderBombEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BlunderBombEntity(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, Level level) {
        super(entityType, shooter, level);
    }

    public BlunderBombEntity(Level level, double x, double y, double z) {
        super(ModEntities.BLUNDER_BOMB.get(), x, y, z, level);
    }

    public void tick() {
        if (!this.level().isClientSide && this.firstTick) {
            this.playSound(SoundEvents.WITCH_THROW, 0.4f, 0.8f);
        }
        super.tick();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Random rand = new Random();
        if (!this.level().isClientSide) {
            this.explodeBomb();
            this.level().broadcastEntityEvent((Entity)this, (byte)42);
            this.level().playSound((Entity)this, this.getOnPos(), ModSounds.BLUNDER_BOMB_EXPLODE.get(), SoundSource.AMBIENT, 2.0f, rand.nextFloat(0.8f, 1.2f));
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            Entity entity = result.getEntity();
            entity.hurt(entity.damageSources().explosion((Entity)this, this.getOwner()), 4.0f);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Entity entity = this.getOwner();
        Level level = this.level();
        BlockPos blockPos = result.getBlockPos();
        BlockState state = level.getBlockState(blockPos);
        Block block = state.getBlock();
        boolean isTNT = block instanceof TntBlock;
        if (isTNT) {
            ((TntBlock)block).onCaughtFire(state, level, blockPos, (Direction)null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
            level.removeBlock(blockPos, false);
        }
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        this.createParticles(this.level(), this.random, this.position());
    }

    private void explodeBomb() {
        AABB aabb = this.getBoundingBox().inflate(5.0, 2.5, 5.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                float distance = this.distanceTo((Entity)entity);
                float damage = this.calculateDamage(distance);
                if (entity.isSpectator() || !entity.hurt(entity.damageSources().explosion((Entity)this, this.getOwner()), damage)) continue;
                Vec3 explosionCenter = this.position();
                Vec3 entityPos = entity.position();
                Vec3 direction = entityPos.subtract(explosionCenter).normalize();
                double knockbackStrength = (1.0 - (double)(distance / 5.0f)) * 0.75 + 0.2;
                entity.knockback(knockbackStrength, -direction.x, -direction.z);
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).hurtMarked = true;
            }
        }
    }

    private void createParticles(Level level, RandomSource random, Vec3 position) {
        int i;
        for (i = 0; i < 100; ++i) {
            double xDir = random.nextDouble() * 1.0 - 0.5;
            double yDir = random.nextDouble() * 1.0 - 0.5;
            double zDir = random.nextDouble() * 1.0 - 0.5;
            double length = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
            double speed = 2.0;
            double xSpeed = (xDir /= length) * speed;
            double ySpeed = (yDir /= length) * speed;
            double zSpeed = (zDir /= length) * speed;
            level.addParticle((ParticleOptions)ModParticles.BLUNDER_BOMB_EXPLOSION_PARTICLES.get(), position.x, position.y, position.z, xSpeed, ySpeed, zSpeed);
        }
        for (i = 0; i < 4; ++i) {
            double xOffset = random.nextDouble() * 0.5 - 0.25;
            double yOffset = random.nextDouble() * 0.5 - 0.25;
            double zOffset = random.nextDouble() * 0.5 - 0.25;
            double xSpeed = random.nextDouble() * 0.8 - 0.4;
            double ySpeed = random.nextDouble() * 0.8 - 0.4;
            double zSpeed = random.nextDouble() * 0.8 - 0.4;
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, position.x + xOffset, position.y + yOffset, position.z + zOffset, xSpeed, ySpeed, zSpeed);
        }
    }

    private float calculateDamage(float distance) {
        float damage = 15.0f * (1.0f - distance / 5.0f);
        return Math.max(damage, 0.0f);
    }

    protected double getDefaultGravity() {
        return 0.055;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity entity, DamageSource damageSource) {
        double d0 = entity.position().x - this.position().x;
        double d1 = entity.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller1", 3, this::flying));
    }

    private PlayState flying(AnimationState<BlunderBombEntity> state) {
        state.getController().setAnimation(FLY);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return ((Entity)object).tickCount;
    }
}

