/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.ShadowSkeletonVariant;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractPowderKegItem;
import net.mrwilfis.treasures_of_the_dead.misc.TOTDBlockPos;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;

public class ShadowSkeletonEntity
extends TOTDSkeletonEntity {
    private static final EntityDataAccessor<Boolean> IS_SHADOW = SynchedEntityData.defineId(ShadowSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SHADOW_TIMER = SynchedEntityData.defineId(ShadowSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean isShaking = false;
    private int shakingTimer = 0;
    private final int shadowTimer = 600;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(ShadowSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ShadowSkeletonEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    @Override
    public void specialProcedures() {
        ShadowSkeletonVariant variant = (ShadowSkeletonVariant)((Object)Util.getRandom((Object[])ShadowSkeletonVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        this.populateDefaultEquipmentSlots(this.random);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 26.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR, 2.0).add(Attributes.MOVEMENT_SPEED, (double)0.24f).build();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller1", 3, this::idleAndWalk2));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller2", 3, this::walkAndAttack2));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller3", 0, this::spawning));
    }

    private PlayState spawning(AnimationState<ShadowSkeletonEntity> state) {
        if (this.getIsSpawning()) {
            state.getController().setAnimation(SPAWN2);
        }
        return PlayState.CONTINUE;
    }

    private PlayState walkAndAttack2(AnimationState<ShadowSkeletonEntity> state) {
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.getShadowTimer() >= 600) {
            if (mainHandItem.getItem() instanceof AbstractPowderKegItem) {
                state.getController().setAnimation(SHAKING_FROM_LIGHT_WITH_KEG);
                state.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(SHAKING_FROM_LIGHT);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.swinging) {
            state.getController().stop();
            state.getController().setAnimation(ATTACK1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().stop();
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.isAggressive()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.isAggressive()) {
            state.getController().setAnimation(WALK_HANDS1);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !this.swinging) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    private PlayState idleAndWalk2(AnimationState<ShadowSkeletonEntity> state) {
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.getIsSpawning()) {
            state.getController().stop();
        }
        if (this.getShadowTimer() >= 600) {
            if (mainHandItem.getItem() instanceof AbstractPowderKegItem) {
                state.getController().setAnimation(SHAKING_FROM_LIGHT_WITH_KEG);
                state.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(SHAKING_FROM_LIGHT);
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.isAggressive() && !mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.6875);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.isAggressive() && !mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(WALK_KEG);
            state.getController().setAnimationSpeed(1.35);
            return PlayState.CONTINUE;
        }
        if (!state.isMoving() && !mainHandItem.isEmpty() && mainHandItem.getItem() instanceof AbstractPowderKegItem) {
            state.getController().setAnimation(IDLE_KEG);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && this.isAggressive()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (state.isMoving() && !this.isAggressive()) {
            state.getController().setAnimation(WALK_BODY1);
            state.getController().setAnimationSpeed(1.0);
            if ((double)this.random.nextFloat() < 0.5) {
                this.idleVariation = 1;
            } else if ((double)this.random.nextFloat() < 1.0) {
                this.idleVariation = 2;
            }
            return PlayState.CONTINUE;
        }
        if (!state.isMoving()) {
            if (this.idleVariation == 1) {
                state.getController().setAnimation(IDLE1);
            } else if (this.idleVariation == 2) {
                state.getController().setAnimation(IDLE2);
            }
            state.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos Pos = this.getLightPosition();
            int j = this.level().getBrightness(LightLayer.BLOCK, Pos);
            int i = this.level().isNight() ? 0 : this.level().getBrightness(LightLayer.SKY, Pos);
            int brightness = Math.max(i, j);
            if (this.isShaking) {
                this.setShadow(false);
                this.setInvulnerable(false);
                this.setNoAi(true);
                --this.shakingTimer;
                if (this.shakingTimer <= 0) {
                    this.setShadowTimer(this.getShadowTimer() - 1);
                    this.isShaking = false;
                    this.setNoAi(false);
                }
            }
            if (brightness >= 7) {
                if (this.getShadow() && !this.isShaking) {
                    this.isShaking = true;
                    this.shakingTimer = 60;
                    this.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, 0.5f, 0.75f);
                    this.playSound(SoundEvents.ALLAY_DEATH, 1.0f, 0.0f);
                    this.setShadowTimer(600);
                }
            } else {
                if (!this.getShadow() && this.getShadowTimer() > 0 && !this.isShaking) {
                    this.setShadowTimer(this.getShadowTimer() - 1);
                }
                if (this.getShadowTimer() <= 0) {
                    this.setShadow(true);
                    this.setInvulnerable(true);
                }
            }
        }
    }

    @Override
    public void populateDefaultEquipmentSlots(RandomSource pRandom) {
        double randomValue = this.random.nextFloat();
        if (randomValue < 0.2) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD), pRandom, 0.5);
        } else if (randomValue < 0.95) {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD), pRandom, 0.5);
        } else {
            this.maybeWearEquipment(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.POWDER_KEG_ITEM.get()), pRandom, 1.0);
        }
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (mainHandItem.getItem() == ModItems.POWDER_KEG_ITEM.get()) {
            this.setLeftHanded(false);
            this.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
        }
    }

    public BlockPos getLightPosition() {
        BlockPos pos = TOTDBlockPos.fromVec3(this.position());
        if (!this.level().getBlockState(pos).canOcclude()) {
            return pos.above();
        }
        return pos;
    }

    public int getShadowTimer() {
        return (Integer)this.getEntityData().get(SHADOW_TIMER);
    }

    public void setShadowTimer(int i) {
        this.getEntityData().set(SHADOW_TIMER, (Object)i);
    }

    public boolean getShadow() {
        return (Boolean)this.getEntityData().get(IS_SHADOW);
    }

    public void setShadow(boolean b) {
        this.getEntityData().set(IS_SHADOW, (Object)b);
    }

    public ShadowSkeletonVariant getShadowVariant() {
        return ShadowSkeletonVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(ShadowSkeletonVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
        this.setShadowTimer(tag.getInt("ShadowTimer"));
        this.setShadow(tag.getBoolean("IsShadow"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getTypeVariant());
        tag.putInt("ShadowTimer", this.getShadowTimer());
        tag.putBoolean("IsShadow", this.getShadow());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(SHADOW_TIMER, (Object)0);
        builder.define(IS_SHADOW, (Object)true);
    }
}

