/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom.chestVariants;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.common.ModDataComponents;
import net.mrwilfis.treasures_of_the_dead.common.ModLootTables;
import net.mrwilfis.treasures_of_the_dead.entity.custom.AbstractChestEntity;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TreasureChestEntity
extends AbstractChestEntity
implements GeoAnimatable,
GeoEntity {
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.defineId(TreasureChestEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ROBBED = SynchedEntityData.defineId(TreasureChestEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE_OPENED = RawAnimation.begin().then("animation.model.idle_opened", Animation.LoopType.LOOP);
    private static final RawAnimation OPENING = RawAnimation.begin().then("animation.model.opening", Animation.LoopType.HOLD_ON_LAST_FRAME);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<TreasureChestEntity> state) {
        if (!this.getIsOpen()) {
            state.getController().setAnimation(IDLE);
        } else {
            state.getController().setAnimationSpeed(1.3);
            state.getController().setAnimation(OPENING);
        }
        return PlayState.CONTINUE;
    }

    public double getTick(Object o) {
        return ((Entity)o).tickCount;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public TreasureChestEntity(EntityType pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    public InteractionResult mobInteract(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack key = pPlayer.getItemInHand(pHand);
        if (pPlayer.isShiftKeyDown()) {
            this.setYRot(pPlayer.getYRot() - 180.0f);
            this.addTag("TOTD_Rotate");
        } else {
            if (!this.getIsRobbed() && key.getItem().equals(ModItems.TREASURE_KEY.get())) {
                this.setIsRobbed(true);
                this.setIsOpen(true);
                this.ejectItems(pPlayer.level());
                if (!pPlayer.isCreative()) {
                    key.shrink(1);
                }
                this.playSound(SoundEvents.FENCE_GATE_OPEN, 0.85f, 0.5f);
                return InteractionResult.SUCCESS;
            }
            if (this.getIsRobbed() && this.getIsOpen()) {
                this.setIsOpen(false);
                this.playSound(SoundEvents.FENCE_GATE_CLOSE, 0.85f, 0.5f);
                return InteractionResult.SUCCESS;
            }
            if (this.getIsRobbed() && !this.getIsOpen()) {
                this.setIsOpen(true);
                this.CreateUnderwaterParticlesOnOpening(pPlayer.level(), (int)this.getX(), (int)this.getY(), (int)this.getZ());
                this.playSound(SoundEvents.FENCE_GATE_OPEN, 0.85f, 0.5f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(pPlayer, pHand);
    }

    private void ejectItems(Level level) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        if (!this.level().isClientSide) {
            LootTable loottable = level.getServer().reloadableRegistries().getLootTable(ModLootTables.DEFAULT_TREASURE_CHEST_LOOT);
            LootParams lootParams = new LootParams.Builder(level.getServer().overworld()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.ZERO).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.GIFT);
            ObjectArrayList list = loottable.getRandomItems(lootParams);
            for (ItemStack itemstack : list) {
                ItemEntity itementity = new ItemEntity(level, x, y, z, itemstack);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
        }
    }

    private void CreateUnderwaterParticlesOnOpening(Level level, int x, int y, int z) {
        boolean isInWater;
        BlockPos pos1 = new BlockPos(x, y, z);
        boolean bl = isInWater = level.getBlockState(pos1).getBlock() == Blocks.WATER;
        if (isInWater) {
            Vec3 position = this.position();
            for (int i = 0; i < 25; ++i) {
                double xOffset = this.random.nextDouble() * 0.5 - 0.25;
                double yOffset = this.random.nextDouble() * 0.5 - 0.25;
                double zOffset = this.random.nextDouble() * 0.5 - 0.25;
                double xSpeed = this.random.nextDouble() * 0.5 - 0.25;
                double ySpeed = this.random.nextDouble() * 0.5;
                double zSpeed = this.random.nextDouble() * 0.5 - 0.25;
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, position.x + xOffset, position.y + yOffset + 0.5, position.z + zOffset, xSpeed, ySpeed + 0.1, zSpeed);
            }
        }
    }

    @Override
    public ItemStack getTreasureItem() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.TREASURE_CHEST_ITEM.get());
        stack.set(ModDataComponents.TREASURE_CHEST_IS_ROBBED, (Object)this.getIsRobbed());
        stack.set(ModDataComponents.TREASURE_CHEST_IS_OPEN, (Object)this.getIsOpen());
        return stack;
    }

    public boolean getIsOpen() {
        return (Boolean)this.getEntityData().get(IS_OPEN);
    }

    public void setIsOpen(boolean var) {
        this.getEntityData().set(IS_OPEN, (Object)var);
    }

    public boolean getIsRobbed() {
        return (Boolean)this.getEntityData().get(IS_ROBBED);
    }

    public void setIsRobbed(boolean var) {
        this.getEntityData().set(IS_ROBBED, (Object)var);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_OPEN, (Object)Boolean.FALSE);
        builder.define(IS_ROBBED, (Object)Boolean.FALSE);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        this.setIsOpen(pCompound.getBoolean("IsOpen"));
        this.setIsRobbed(pCompound.getBoolean("IsRobbed"));
        super.readAdditionalSaveData(pCompound);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putBoolean("IsOpen", this.getIsOpen());
        pCompound.putBoolean("IsRobbed", this.getIsRobbed());
        super.addAdditionalSaveData(pCompound);
    }
}

