/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit;

import com.mojang.math.Transformation;
import dev.obscuria.displayedit.mixin.BlockDisplayAccessor;
import dev.obscuria.displayedit.mixin.DisplayAccessor;
import dev.obscuria.displayedit.mixin.ItemDisplayAccessor;
import dev.obscuria.displayedit.mixin.TextDisplayAccessor;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Helper {
    private static final byte FLAG_SHADOW = 1;
    private static final byte FLAG_SEE_THROUGH = 2;
    private static final byte FLAG_DEFAULT_BACKGROUND = 4;
    private static final byte FLAG_ALIGN_LEFT = 8;
    private static final byte FLAG_ALIGN_RIGHT = 16;

    public static boolean isLocked(@Nullable Display display) {
        return display == null || display.isInvulnerable();
    }

    public static void setLocked(Display display, boolean locked) {
        display.setInvulnerable(locked);
    }

    public static Transformation getTransformation(Display display) {
        return DisplayAccessor.invokeCreateTransformation(display.getEntityData());
    }

    public static Vec3 getTranslation(Display display) {
        return new Vec3(Helper.getTransformation(display).getTranslation());
    }

    public static Vec3 getScale(Display display) {
        return new Vec3(Helper.getTransformation(display).getScale());
    }

    public static Vec3 getLeftRotation(Display display) {
        return Helper.degreesOf(Helper.getTransformation(display).getLeftRotation());
    }

    public static Vec3 getRightRotation(Display display) {
        return Helper.degreesOf(Helper.getTransformation(display).getRightRotation());
    }

    public static void setTransformation(Display display, Transformation transformation) {
        ((DisplayAccessor)display).invokeSetTransformation(transformation);
    }

    public static void setTranslation(Display display, Vec3 translation) {
        Helper.setTransformation(display, Helper.withTranslation(Helper.getTransformation(display), translation));
    }

    public static void setScale(Display display, Vec3 scale) {
        Helper.setTransformation(display, Helper.withScale(Helper.getTransformation(display), scale));
    }

    public static void setLeftRotation(Display display, Vec3 rotation) {
        Helper.setTransformation(display, Helper.withLeftRotation(Helper.getTransformation(display), rotation));
    }

    public static void setRightRotation(Display display, Vec3 rotation) {
        Helper.setTransformation(display, Helper.withRightRotation(Helper.getTransformation(display), rotation));
    }

    public static Transformation withTranslation(Transformation original, Vec3 translation) {
        return new Transformation(translation.toVector3f(), new Quaternionf((Quaternionfc)original.getLeftRotation()), new Vector3f((Vector3fc)original.getScale()), new Quaternionf((Quaternionfc)original.getRightRotation()));
    }

    public static Transformation withScale(Transformation original, Vec3 scale) {
        return new Transformation(new Vector3f((Vector3fc)original.getTranslation()), new Quaternionf((Quaternionfc)original.getLeftRotation()), scale.toVector3f(), new Quaternionf((Quaternionfc)original.getRightRotation()));
    }

    public static Transformation withLeftRotation(Transformation original, Vec3 rotation) {
        return new Transformation(new Vector3f((Vector3fc)original.getTranslation()), Helper.quaternionOf(rotation), new Vector3f((Vector3fc)original.getScale()), new Quaternionf((Quaternionfc)original.getRightRotation()));
    }

    public static Transformation withRightRotation(Transformation original, Vec3 rotation) {
        return new Transformation(new Vector3f((Vector3fc)original.getTranslation()), new Quaternionf((Quaternionfc)original.getLeftRotation()), new Vector3f((Vector3fc)original.getScale()), Helper.quaternionOf(rotation));
    }

    public static Vec3 degreesOf(Quaternionf quaternion) {
        return new Vec3(quaternion.getEulerAnglesXYZ(new Vector3f()).mul(57.29578f));
    }

    public static Quaternionf quaternionOf(Vec3 degrees) {
        Vector3f radians = degrees.toVector3f().mul((float)Math.PI / 180);
        return new Quaternionf().rotationXYZ(radians.x, radians.y, radians.z);
    }

    public static Display.BillboardConstraints getBillboardConstraints(Display display) {
        return ((DisplayAccessor)display).invokeGetBillboardConstraints();
    }

    public static void setBillboardConstraints(Display display, Display.BillboardConstraints constraints) {
        ((DisplayAccessor)display).invokeSetBillboardConstraints(constraints);
    }

    public static float getViewRange(Display display) {
        return ((DisplayAccessor)display).invokeGetViewRange();
    }

    public static void setViewRange(Display display, float range) {
        ((DisplayAccessor)display).invokeSetViewRange(range);
    }

    @Nullable
    public static Brightness getBrightnessOverride(Display display) {
        return ((DisplayAccessor)display).invokeGetBrightnessOverride();
    }

    public static void setBrightnessOverride(Display display, @Nullable Brightness brightness) {
        ((DisplayAccessor)display).invokeSetBrightnessOverride(brightness);
    }

    public static BlockState getBlockState(Display.BlockDisplay display) {
        return ((BlockDisplayAccessor)display).invokeGetBlockState();
    }

    public static void setBlockState(Display.BlockDisplay display, BlockState state) {
        ((BlockDisplayAccessor)display).invokeSetBlockState(state);
    }

    public static ItemStack getItemStack(Display.ItemDisplay display) {
        return ((ItemDisplayAccessor)display).invokeGetItemStack();
    }

    public static void setItemStack(Display.ItemDisplay display, ItemStack stack) {
        ((ItemDisplayAccessor)display).invokeSetItemStack(stack);
    }

    public static ItemDisplayContext getItemTransform(Display.ItemDisplay display) {
        return ((ItemDisplayAccessor)display).invokeGetItemTransform();
    }

    public static void setItemTransform(Display.ItemDisplay display, ItemDisplayContext context) {
        ((ItemDisplayAccessor)display).invokeSetItemTransform(context);
    }

    public static Component getText(Display.TextDisplay display) {
        return ((TextDisplayAccessor)display).invokeGetText();
    }

    public static void setText(Display.TextDisplay display, Component text) {
        ((TextDisplayAccessor)display).invokeSetText(text);
    }

    public static byte getFlags(Display.TextDisplay display) {
        return ((TextDisplayAccessor)display).invokeGetFlags();
    }

    public static void setFlags(Display.TextDisplay display, byte flags) {
        ((TextDisplayAccessor)display).invokeSetFlags(flags);
    }

    private static void updateFlag(Display.TextDisplay display, byte flag, boolean enable) {
        byte flags = Helper.getFlags(display);
        flags = enable ? (byte)(flags | flag) : (byte)(flags & ~flag);
        Helper.setFlags(display, flags);
    }

    public static boolean hasShadow(Display.TextDisplay display) {
        return (Helper.getFlags(display) & 1) != 0;
    }

    public static void setShadow(Display.TextDisplay display, boolean value) {
        Helper.updateFlag(display, (byte)1, value);
    }

    public static boolean hasSeeThrough(Display.TextDisplay display) {
        return (Helper.getFlags(display) & 2) != 0;
    }

    public static void setSeeThrough(Display.TextDisplay display, boolean value) {
        Helper.updateFlag(display, (byte)2, value);
    }

    public static boolean hasDefaultBackground(Display.TextDisplay display) {
        return (Helper.getFlags(display) & 4) != 0;
    }

    public static void setDefaultBackground(Display.TextDisplay display, boolean value) {
        Helper.updateFlag(display, (byte)4, value);
    }

    public static Display.TextDisplay.Align getAlign(Display.TextDisplay display) {
        byte flags = Helper.getFlags(display);
        if ((flags & 8) != 0) {
            return Display.TextDisplay.Align.LEFT;
        }
        if ((flags & 0x10) != 0) {
            return Display.TextDisplay.Align.RIGHT;
        }
        return Display.TextDisplay.Align.CENTER;
    }

    public static void setAlign(Display.TextDisplay display, Display.TextDisplay.Align align) {
        byte flags = Helper.getFlags(display);
        flags = (byte)(flags & 0xFFFFFFE7);
        switch (align) {
            case LEFT: {
                flags = (byte)(flags | 8);
                break;
            }
            case RIGHT: {
                flags = (byte)(flags | 0x10);
                break;
            }
        }
        Helper.setFlags(display, flags);
    }

    public static int getBackgroundColor(Display.TextDisplay display) {
        return ((TextDisplayAccessor)display).invokeGetBackgroundColor();
    }

    public static void setBackgroundColor(Display.TextDisplay display, int color) {
        ((TextDisplayAccessor)display).invokeSetBackgroundColor(color);
    }

    public static int getLineWidth(Display.TextDisplay display) {
        return ((TextDisplayAccessor)display).invokeGetLineWidth();
    }

    public static void setLineWidth(Display.TextDisplay display, int width) {
        ((TextDisplayAccessor)display).invokeSetLineWidth(width);
    }

    public static byte getTextOpacity(Display.TextDisplay display) {
        return ((TextDisplayAccessor)display).invokeGetTextOpacity();
    }

    public static void setTextOpacity(Display.TextDisplay display, byte opacity) {
        ((TextDisplayAccessor)display).invokeSetTextOpacity(opacity);
    }
}

