/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;

public record Brush(String key, double[] values) {
    public static final Brush POSITION = new Brush("position", new double[]{1.0, 0.0625, 0.0125, 0.0025});
    public static final Brush SCALE = new Brush("scale", new double[]{1.0, 0.0625, 0.0125, 0.0025});
    public static final Brush ROTATION = new Brush("rotation", new double[]{90.0, 45.0, 22.5, 1.0});
    private static final Map<Brush, Integer> SIZE_CACHE = new HashMap<Brush, Integer>();

    public int size() {
        return SIZE_CACHE.getOrDefault(this, 0);
    }

    public double value() {
        return this.values[this.size()];
    }

    public void cycle() {
        SIZE_CACHE.compute(this, (brush, size) -> ((size == null ? 0 : size) + 1) % this.values.length);
    }

    public Component name() {
        return Component.translatable((String)"editor.brush.%s.%s".formatted(this.key, this.size()));
    }
}

