/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.widgets.EditorButton;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DisplaySelector {
    private final List<Display> displays = Lists.newArrayList();
    private int selectedIndex = 0;
    @Nullable
    public Display selected;
    public int x;
    public int y;

    public DisplaySelector(boolean raycast) {
        this.initialize(raycast);
    }

    public void build(EditorScreen screen) {
        screen.add(new EditorButton((Component)Component.literal((String)"<"), this.x - 73, this.y + 2, 14, 14, this::previous));
        screen.add(new EditorButton((Component)Component.literal((String)">"), this.x + 59, this.y + 2, 14, 14, this::next));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.fillGradient(this.x - 75, this.y, this.x + 75, this.y + 18, -1072689136, -804253680);
        if (this.displays.isEmpty()) {
            MutableComponent line = Component.literal((String)"Nothing Selected").withStyle(ChatFormatting.DARK_GRAY);
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)line, this.x, this.y + 5, -1);
        } else {
            MutableComponent size = Component.empty().append((Component)Component.literal((String)String.valueOf(this.selectedIndex + 1)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("/" + this.displays.size())).withStyle(ChatFormatting.DARK_GRAY));
            MutableComponent line = Component.empty().append(this.displayName()).append(CommonComponents.SPACE).append((Component)size);
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)line, this.x, this.y + 5, -1);
        }
    }

    public void tick() {
        this.displays.removeIf(Entity::isRemoved);
        this.maybeUpdateSelection();
    }

    public void select(Display display) {
        if (this.displays.contains(display)) {
            this.selectedIndex = this.displays.indexOf(display);
        } else {
            this.displays.add(display);
            this.selectedIndex = this.displays.size() - 1;
        }
        this.maybeUpdateSelection();
    }

    private void initialize(boolean raycast) {
        this.displays.clear();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        HashSet result = new HashSet();
        Vec3 origin = player.getEyePosition();
        if (raycast) {
            Vec3 direction = player.getLookAngle();
            for (int i = 0; i < 20; ++i) {
                Vec3 pos = origin.add(direction.scale(2.0 + 0.1 * (double)i));
                AABB area = new AABB(pos, pos).inflate(2.0);
                result.addAll(player.level().getEntitiesOfClass(Display.class, area, (Predicate)Predicates.alwaysTrue()));
            }
        } else {
            AABB area = new AABB(origin, origin).inflate(32.0);
            result.addAll(player.level().getEntitiesOfClass(Display.class, area, (Predicate)Predicates.alwaysTrue()));
        }
        this.displays.addAll(result.stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(origin))).toList());
        this.maybeUpdateSelection();
    }

    @Nullable
    private Display getSelectedDisplay() {
        if (this.displays.isEmpty()) {
            return null;
        }
        if (this.displays.size() == 1) {
            return this.displays.getFirst();
        }
        return this.displays.get(Mth.clamp((int)this.selectedIndex, (int)0, (int)(this.displays.size() - 1)));
    }

    private void next(Button button) {
        ++this.selectedIndex;
        if (this.selectedIndex > this.displays.size() - 1) {
            this.selectedIndex = 0;
        }
        this.maybeUpdateSelection();
    }

    private void previous(Button button) {
        --this.selectedIndex;
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.displays.size() - 1;
        }
        this.maybeUpdateSelection();
    }

    private void maybeUpdateSelection() {
        if (Objects.equals(this.selected, this.getSelectedDisplay())) {
            return;
        }
        this.selectedIndex = this.displays.size() > 1 ? Mth.clamp((int)this.selectedIndex, (int)0, (int)(this.displays.size() - 1)) : 0;
        this.selected = this.getSelectedDisplay();
        EditorScreen.rebuild();
    }

    private Component displayName() {
        String rawName;
        Display display = this.selected;
        if (display instanceof Display.BlockDisplay) {
            Display.BlockDisplay display2 = (Display.BlockDisplay)display;
            v0 = Helper.getBlockState(display2).getBlock().getName().getString();
        } else {
            display = this.selected;
            if (display instanceof Display.ItemDisplay) {
                Display.ItemDisplay display3 = (Display.ItemDisplay)display;
                v0 = Helper.getItemStack(display3).getHoverName().getString();
            } else {
                display = this.selected;
                if (display instanceof Display.TextDisplay) {
                    Display.TextDisplay display4 = (Display.TextDisplay)display;
                    v0 = Helper.getText(display4).getString();
                } else {
                    v0 = rawName = "Empty";
                }
            }
        }
        if (rawName.length() <= 12) {
            return Component.literal((String)rawName);
        }
        return Component.literal((String)(rawName.substring(0, 12) + "..."));
    }
}

