/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class EditorCameraController {
    public static boolean active = false;
    public static Vec3 position = Vec3.ZERO;
    public static float yaw = 0.0f;
    public static float pitch = 0.0f;
    private static Vec3 focusPosition = Vec3.ZERO;
    private static float startYaw = 0.0f;
    private static float startPitch = 0.0f;
    private static float focusYaw = 0.0f;
    private static float focusPitch = 0.0f;
    private static float theta = 0.0f;
    private static float radius = 4.0f;
    private static float ascent = 1.0f;
    @Nullable
    private static Display lastDisplay = null;
    private static long startRotationTime = Util.getMillis();
    private static long startFadeOutTime = 0L;

    public static void enable() {
        active = true;
        lastDisplay = null;
        radius = 4.0f;
        ascent = 1.0f;
        Optional.ofNullable(Minecraft.getInstance().player).ifPresent(player -> {
            position = player.getEyePosition();
            yaw = player.getYRot();
            pitch = player.getXRot();
        });
    }

    public static void update(@Nullable Display display) {
        Vec3 focus;
        Vec3 vec3 = focus = display == null ? Vec3.ZERO : display.position();
        if (!Objects.equals(focusPosition, focus)) {
            startRotationTime = Util.getMillis();
            focusPosition = focus;
            startYaw = yaw;
            startPitch = pitch;
        }
        if (!Objects.equals(lastDisplay, display)) {
            startRotationTime = Util.getMillis();
            lastDisplay = display;
            startYaw = yaw;
            startPitch = pitch;
            Vec3 direction = position.subtract(focusPosition).lengthSqr() < 0.01 ? new Vec3(1.0, 0.0, 0.0) : position.subtract(focusPosition);
            theta = (float)Math.atan2(direction.z, direction.x);
        }
        if (display == null) {
            return;
        }
        float delta = Math.min(Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks() / 20.0f, 0.05f);
        Vec3 target = new Vec3(EditorCameraController.focusPosition.x + Math.cos(theta) * (double)radius, EditorCameraController.focusPosition.y + (double)ascent, EditorCameraController.focusPosition.z + Math.sin(theta) * (double)radius);
        position = position.lerp(target, (double)(delta * 3.0f));
        Vec3 rotation = focusPosition.subtract(position).normalize();
        focusYaw = (float)(Math.toDegrees(Math.atan2(rotation.z, rotation.x)) - 90.0);
        focusPitch = (float)(-Math.toDegrees(Math.asin(rotation.y)));
        float progress = EditorCameraController.computeProgress(startRotationTime, 500.0);
        yaw = Mth.rotLerp((float)progress, (float)startYaw, (float)focusYaw);
        pitch = Mth.rotLerp((float)progress, (float)startPitch, (float)focusPitch);
    }

    public static void moveLeft() {
        theta -= 0.5f;
    }

    public static void moveRight() {
        theta += 0.5f;
    }

    public static void moveUp() {
        ascent += 1.0f;
    }

    public static void moveDown() {
        ascent -= 1.0f;
    }

    public static void moveForward() {
        radius -= 1.0f;
        radius = Mth.clamp((float)radius, (float)0.5f, (float)20.0f);
    }

    public static void moveBackward() {
        radius += 1.0f;
        radius = Mth.clamp((float)radius, (float)0.5f, (float)20.0f);
    }

    public static void disable() {
        active = false;
        lastDisplay = null;
        startFadeOutTime = Util.getMillis();
    }

    public static Vec3 translatePosition(Vec3 cameraPosition) {
        if (active) {
            return position;
        }
        float progress = EditorCameraController.computeProgress(startFadeOutTime, 1000.0);
        if (progress >= 1.0f) {
            return cameraPosition;
        }
        return position.lerp(cameraPosition, (double)progress);
    }

    public static float translateYaw(float cameraYaw) {
        if (active) {
            return yaw;
        }
        float progress = EditorCameraController.computeProgress(startFadeOutTime, 1000.0);
        if (progress >= 1.0f) {
            return cameraYaw;
        }
        return Mth.rotLerp((float)progress, (float)yaw, (float)cameraYaw);
    }

    public static float translatePitch(float cameraPitch) {
        if (active) {
            return pitch;
        }
        float progress = EditorCameraController.computeProgress(startFadeOutTime, 1000.0);
        if (progress >= 1.0f) {
            return cameraPitch;
        }
        return Mth.rotLerp((float)progress, (float)pitch, (float)cameraPitch);
    }

    private static float computeProgress(long startTime, double duration) {
        double delta = Math.min(1.0, (double)(Util.getMillis() - startTime) / duration);
        return 1.0f - (float)Math.pow(1.0 - delta, 3.0);
    }
}

