/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.obscuria.displayedit.client.DisplaySelector;
import dev.obscuria.displayedit.client.EditorCameraController;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.sections.BlockStateSection;
import dev.obscuria.displayedit.client.sections.ItemStackSection;
import dev.obscuria.displayedit.client.sections.LeftRotationSection;
import dev.obscuria.displayedit.client.sections.ManagerSection;
import dev.obscuria.displayedit.client.sections.PositionSection;
import dev.obscuria.displayedit.client.sections.PropertySection;
import dev.obscuria.displayedit.client.sections.RightRotationSection;
import dev.obscuria.displayedit.client.sections.ScaleSection;
import dev.obscuria.displayedit.client.sections.TextSection;
import dev.obscuria.displayedit.client.sections.TranslationSection;
import dev.obscuria.displayedit.client.widgets.TextField;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Display;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EditorScreen
extends Screen {
    private static final int SEPARATION = 2;
    private final List<AbstractEditorSection> leftSection = Lists.newArrayList();
    private final List<AbstractEditorSection> rightSections = Lists.newArrayList();
    private final DisplaySelector selector;

    public EditorScreen(boolean raycast) {
        super((Component)Component.literal((String)"Display Edit"));
        this.selector = new DisplaySelector(raycast);
        EditorCameraController.enable();
    }

    public <T extends GuiEventListener & Renderable> T add(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.selector.render(graphics, mouseX, mouseY, delta);
        this.leftSection.forEach(section -> section.render(graphics, mouseX, mouseY, delta));
        this.rightSections.forEach(section -> section.render(graphics, mouseX, mouseY, delta));
        super.render(graphics, mouseX, mouseY, delta);
        EditorCameraController.update(this.selector.selected);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.getFocused() instanceof TextField) {
            if (keyCode == 257) {
                EditorScreen.apply();
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 65) {
            EditorCameraController.moveRight();
            return true;
        }
        if (keyCode == 68) {
            EditorCameraController.moveLeft();
            return true;
        }
        if (keyCode == 87) {
            EditorCameraController.moveUp();
            return true;
        }
        if (keyCode == 83) {
            EditorCameraController.moveDown();
            return true;
        }
        if (keyCode == 45) {
            EditorCameraController.moveBackward();
            return true;
        }
        if (keyCode == 61) {
            EditorCameraController.moveForward();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        EditorCameraController.disable();
    }

    protected void init() {
        this.leftSection.removeIf(AbstractEditorSection::invalidate);
        this.rightSections.removeIf(AbstractEditorSection::invalidate);
        this.leftSection.add(new PositionSection());
        this.leftSection.add(new TranslationSection());
        this.leftSection.add(new ScaleSection());
        this.leftSection.add(new LeftRotationSection());
        this.leftSection.add(new RightRotationSection());
        this.rightSections.add(new ManagerSection());
        this.rightSections.add(new BlockStateSection());
        this.rightSections.add(new ItemStackSection());
        this.rightSections.add(new TextSection());
        this.rightSections.add(new PropertySection());
        this.selector.x = this.width / 2;
        this.selector.y = 2;
        this.selector.build(this);
        this.buildSections(2, this.leftSection);
        this.buildSections(this.width - 120 - 2, this.rightSections);
    }

    public void tick() {
        this.selector.tick();
    }

    protected void rebuildWidgets() {
        super.rebuildWidgets();
        this.setFocused(null);
    }

    private void buildSections(int x, List<AbstractEditorSection> sections) {
        int yOffset = 2;
        for (AbstractEditorSection section : sections) {
            section.x = x;
            section.y = yOffset;
            section.build(this, this.selector.selected);
            yOffset += section.height() + 2;
        }
    }

    public static void rebuild() {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof EditorScreen)) {
            return;
        }
        EditorScreen editor = (EditorScreen)screen;
        editor.rebuildWidgets();
    }

    public static void apply() {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof EditorScreen)) {
            return;
        }
        EditorScreen editor = (EditorScreen)screen;
        Display selected = editor.selector.selected;
        if (selected == null) {
            return;
        }
        editor.leftSection.forEach(section -> section.maybeApply(selected));
        editor.rightSections.forEach(section -> section.maybeApply(selected));
        EditorScreen.rebuild();
    }

    public static boolean isSelected(Display display) {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof EditorScreen)) {
            return false;
        }
        EditorScreen editor = (EditorScreen)screen;
        return editor.selector.selected == display;
    }

    @Nullable
    public static Display getSelected() {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof EditorScreen)) {
            return null;
        }
        EditorScreen editor = (EditorScreen)screen;
        return editor.selector.selected;
    }

    public static void select(Display display) {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof EditorScreen)) {
            return;
        }
        EditorScreen editor = (EditorScreen)screen;
        editor.selector.select(display);
    }

    public static void renderGizmo(PoseStack pose, MultiBufferSource.BufferSource source, double camX, double camY, double camZ) {
        Display selected = EditorScreen.getSelected();
        if (selected == null) {
            return;
        }
        pose.pushPose();
        pose.translate(selected.getX() - camX, selected.getY() - camY, selected.getZ() - camZ);
        ShapeRenderer.renderVector((PoseStack)pose, (VertexConsumer)source.getBuffer(RenderType.debugLine((double)5.0)), (Vector3f)new Vector3f(), (Vec3)new Vec3(16.0, 0.0, 0.0), (int)-65536);
        ShapeRenderer.renderVector((PoseStack)pose, (VertexConsumer)source.getBuffer(RenderType.debugLine((double)5.0)), (Vector3f)new Vector3f(), (Vec3)new Vec3(0.0, 16.0, 0.0), (int)-16711936);
        ShapeRenderer.renderVector((PoseStack)pose, (VertexConsumer)source.getBuffer(RenderType.debugLine((double)5.0)), (Vector3f)new Vector3f(), (Vec3)new Vec3(0.0, 0.0, 16.0), (int)-16776961);
        pose.popPose();
    }
}

