/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.widgets.SectionExpandButton;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Display;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class AbstractEditorSection {
    public static final int SECTION_WIDTH = 120;
    public static final int SECTION_HEADER = 16;
    public static final int PANEL_WIDTH = 112;
    public final SectionType type;
    public boolean locked = false;
    public boolean active = true;
    public boolean isValid = true;
    public boolean isDirty = false;
    public int x;
    public int y;

    protected AbstractEditorSection(SectionType type) {
        this.type = type;
    }

    public abstract void buildExpanded(EditorScreen var1, @Nullable Display var2);

    public abstract void renderExpanded(GuiGraphics var1, int var2, int var3, float var4);

    public boolean invalidate() {
        this.isValid = false;
        return true;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void maybeApply(Display display) {
        if (!this.isValid || !this.isDirty) {
            return;
        }
        this.apply(display);
        this.isDirty = false;
    }

    public int height() {
        return this.type.isExpanded() ? this.expandedHeight() : this.collapsedHeight();
    }

    public void build(EditorScreen screen, @Nullable Display display) {
        screen.add(new SectionExpandButton(this.type, this.x + 105, this.y + 1));
        this.locked = Helper.isLocked(display);
        this.active = this.isActive(display);
        if (!this.type.isExpanded()) {
            return;
        }
        this.buildExpanded(screen, display);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawWindow(graphics, this.displayName(), this.x, this.y, 120, this.height(), this.active);
        if (!this.type.isExpanded()) {
            return;
        }
        this.renderExpanded(graphics, mouseX, mouseY, delta);
    }

    protected abstract void apply(Display var1);

    protected abstract int expandedHeight();

    protected abstract boolean isActive(@Nullable Display var1);

    protected int collapsedHeight() {
        return 16;
    }

    protected Component displayName() {
        return this.type.displayName;
    }

    protected void drawWindow(GuiGraphics graphics, Component title, int x, int y, int width, int height, boolean active) {
        graphics.fillGradient(x, y, x + width, y + height, -1072689136, -804253680);
        graphics.renderOutline(x, y, width, height, -16777216);
        graphics.hLine(x, x + width - 1, y, -12566464);
        graphics.fill(x + 1, y + 1, x + width - 1, y + 15, -15460840);
        Font font = Minecraft.getInstance().font;
        int textWidth = 6 + font.width((FormattedText)title);
        int mainColor = active ? -16744384 : -13619152;
        graphics.drawSpecial(provider -> {
            Matrix4f matrix = graphics.pose().last().pose();
            VertexConsumer consumer = provider.getBuffer(RenderType.guiOverlay());
            consumer.addVertex(matrix, (float)(x + 1), (float)(y + 1), 0.0f).setColor(mainColor);
            consumer.addVertex(matrix, (float)(x + 1), (float)(y + 15), 0.0f).setColor(mainColor);
            consumer.addVertex(matrix, (float)(x + textWidth), (float)(y + 15), 0.0f).setColor(mainColor);
            consumer.addVertex(matrix, (float)(x + textWidth + 10), (float)(y + 1), 0.0f).setColor(mainColor);
        });
        MutableComponent formattedTitle = title.copy().withStyle(active ? ChatFormatting.WHITE : ChatFormatting.DARK_GRAY);
        graphics.drawString(font, (Component)formattedTitle, x + 4, y + 4, -1, false);
    }

    protected void drawPanel(GuiGraphics graphics, String title, int x, int y, int width, int height) {
        graphics.fillGradient(x, y, x + width, y + height, -871098856, -585886184);
        graphics.renderOutline(x, y, width, height, -11513260);
        graphics.drawCenteredString(Minecraft.getInstance().font, title, x + width / 2, y + 5, 0xAAAAAA);
    }
}

