/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import dev.obscuria.displayedit.client.Brush;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.widgets.BrushButton;
import dev.obscuria.displayedit.client.widgets.DoubleField;
import dev.obscuria.displayedit.client.widgets.EditorButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Display;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTransformSection
extends AbstractEditorSection {
    private final List<Consumer<Vec3>> vectorListeners = Lists.newArrayList();
    private final Brush brush;
    private Vec3 vector;
    @Nullable
    private String fieldX;
    @Nullable
    private String fieldY;
    @Nullable
    private String fieldZ;

    protected AbstractTransformSection(SectionType type, Vec3 vector, Brush brush) {
        super(type);
        this.vector = vector;
        this.brush = brush;
    }

    @Override
    public void buildExpanded(EditorScreen screen, @Nullable Display display) {
        if (this.active) {
            screen.add(new BrushButton(this.brush, this.x + 91, this.y + 2));
        }
        screen.add(new EditorButton.Decrement(this.x + 14, this.y + 20, this.active, () -> this.add(-this.brush.value(), 0.0, 0.0)));
        screen.add(new EditorButton.Decrement(this.x + 14, this.y + 36, this.active, () -> this.add(0.0, -this.brush.value(), 0.0)));
        screen.add(new EditorButton.Decrement(this.x + 14, this.y + 52, this.active, () -> this.add(0.0, 0.0, -this.brush.value())));
        screen.add(new EditorButton.Increment(this.x + 100, this.y + 20, this.active, () -> this.add(this.brush.value(), 0.0, 0.0)));
        screen.add(new EditorButton.Increment(this.x + 100, this.y + 36, this.active, () -> this.add(0.0, this.brush.value(), 0.0)));
        screen.add(new EditorButton.Increment(this.x + 100, this.y + 52, this.active, () -> this.add(0.0, 0.0, this.brush.value())));
        DoubleField fieldX = screen.add(new DoubleField(this.x + 30, this.y + 21, 68, 12, this.active));
        DoubleField fieldY = screen.add(new DoubleField(this.x + 30, this.y + 37, 68, 12, this.active));
        DoubleField fieldZ = screen.add(new DoubleField(this.x + 30, this.y + 53, 68, 12, this.active));
        fieldX.setResponder(this::fiendXChanged);
        fieldY.setResponder(this::fiendYChanged);
        fieldZ.setResponder(this::fiendZChanged);
        this.vectorListeners.add(value -> {
            fieldX.setDouble(value.x);
            fieldY.setDouble(value.y);
            fieldZ.setDouble(value.z);
        });
        this.initialize(display);
    }

    @Override
    public void renderExpanded(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Font font = Minecraft.getInstance().font;
        this.drawPanel(graphics, "", this.x + 4, this.y + 18, 112, 50);
        graphics.drawString(font, "X", this.x + 7, this.y + 23, 0xFF5555, true);
        graphics.drawString(font, "Y", this.x + 7, this.y + 39, 0x55FF55, true);
        graphics.drawString(font, "Z", this.x + 7, this.y + 55, 0x5555FF, true);
    }

    protected abstract Vec3 extractFrom(Display var1);

    protected Vec3 vector() {
        return new Vec3(this.parse(this.fieldX, this.vector.x), this.parse(this.fieldY, this.vector.y), this.parse(this.fieldZ, this.vector.z));
    }

    protected void initialize(@Nullable Display display) {
        if (display != null) {
            this.vector = this.extractFrom(display);
        }
        this.broadcastUpdated();
    }

    protected void broadcastUpdated() {
        this.vectorListeners.forEach(it -> it.accept(this.vector));
    }

    @Override
    protected int expandedHeight() {
        return 72;
    }

    @Override
    protected boolean isActive(@Nullable Display display) {
        return display != null && !this.locked;
    }

    private void add(double x, double y, double z) {
        this.vector = this.vector.add(x, y, z);
        this.isDirty = true;
        this.broadcastUpdated();
        EditorScreen.apply();
    }

    private void fiendXChanged(String field) {
        this.fieldX = field;
        this.markDirty();
    }

    private void fiendYChanged(String field) {
        this.fieldY = field;
        this.markDirty();
    }

    private void fiendZChanged(String field) {
        this.fieldZ = field;
        this.markDirty();
    }

    private double parse(@Nullable String value, double fallback) {
        try {
            if (value == null) {
                return fallback;
            }
            return Double.parseDouble(value);
        }
        catch (Exception ignored) {
            return fallback;
        }
    }
}

