/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.widgets.LocationField;
import dev.obscuria.displayedit.client.widgets.PropertyButton;
import dev.obscuria.displayedit.network.ServerboundBlockStatePayload;
import dev.obscuria.displayedit.platform.Services;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Display;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public final class BlockStateSection
extends AbstractEditorSection {
    private final List<Property<?>> properties = Lists.newArrayList();
    private final List<Property.Value<?>> changedValues = Lists.newArrayList();
    @Nullable
    private String fieldName;

    public BlockStateSection() {
        super(SectionType.BLOCK_STATE);
    }

    @Override
    public void buildExpanded(EditorScreen screen, @Nullable Display display) {
        this.buildPropertyList(display);
        LocationField fieldName = screen.add(new LocationField(this.x + 7, this.y + 36, 106, 12, this.active));
        fieldName.setLocation(this.getBlockName(display));
        fieldName.setResponder(this::fieldNameChanged);
        if (display instanceof Display.BlockDisplay) {
            Display.BlockDisplay blockDisplay = (Display.BlockDisplay)display;
            BlockState state = Helper.getBlockState(blockDisplay);
            int yOffset = 0;
            for (Property<?> property : this.properties) {
                PropertyButton button = screen.add(new PropertyButton(property, this.x + 64, this.y + 69 + yOffset, 50, 14, this.active, this::propertyChanged));
                button.setValue(state.getValue(property));
                yOffset += 15;
            }
        }
    }

    @Override
    public void renderExpanded(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawPanel(graphics, "Name", this.x + 4, this.y + 18, 112, 33);
        String panelName = this.properties.isEmpty() ? "No Properties" : "Properties";
        this.drawPanel(graphics, panelName, this.x + 4, this.y + 52, 112, 18 + this.properties.size() * 15);
        Font font = Minecraft.getInstance().font;
        int color = this.active ? -1 : 0x555555;
        int yOffset = 0;
        for (Property<?> property : this.properties) {
            graphics.drawString(font, property.getName(), this.x + 7, this.y + 72 + yOffset, color, true);
            yOffset += 15;
        }
    }

    @Override
    protected void apply(Display display) {
        if (!(display instanceof Display.BlockDisplay)) {
            return;
        }
        Display.BlockDisplay blockDisplay = (Display.BlockDisplay)display;
        if (this.maybeApplyByName(blockDisplay)) {
            return;
        }
        this.maybeApplyProperties(blockDisplay);
    }

    @Override
    protected int expandedHeight() {
        return 74 + this.properties.size() * 15;
    }

    @Override
    protected boolean isActive(@Nullable Display display) {
        return !this.locked && display instanceof Display.BlockDisplay;
    }

    private void fieldNameChanged(String name) {
        this.fieldName = name;
        this.markDirty();
    }

    private void propertyChanged(Property.Value<?> value) {
        this.changedValues.add(value);
        this.markDirty();
        EditorScreen.apply();
    }

    @Nullable
    private ResourceLocation getBlockName(@Nullable Display display) {
        if (!(display instanceof Display.BlockDisplay)) {
            return null;
        }
        Display.BlockDisplay blockDisplay = (Display.BlockDisplay)display;
        return Helper.getBlockState(blockDisplay).getBlock().builtInRegistryHolder().key().location();
    }

    private boolean maybeApplyByName(Display.BlockDisplay display) {
        BlockState state = this.parseBlockState();
        if (state == null) {
            return false;
        }
        Helper.setBlockState(display, state);
        Services.PLATFORM.sendToServer(ServerboundBlockStatePayload.state((Display)display, state));
        return true;
    }

    private void maybeApplyProperties(Display.BlockDisplay display) {
        if (this.changedValues.isEmpty()) {
            return;
        }
        BlockState state = Helper.getBlockState(display);
        for (Property.Value<?> value : this.changedValues) {
            state = BlockStateSection.apply(state, value.property(), value.value());
        }
        Helper.setBlockState(display, state);
        Services.PLATFORM.sendToServer(ServerboundBlockStatePayload.state((Display)display, state));
    }

    @Nullable
    private BlockState parseBlockState() {
        if (this.fieldName == null) {
            return null;
        }
        try {
            ResourceLocation location = ResourceLocation.parse((String)this.fieldName);
            Holder.Reference block = (Holder.Reference)BuiltInRegistries.BLOCK.get(location).orElseThrow();
            return ((Block)block.value()).defaultBlockState();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void buildPropertyList(@Nullable Display display) {
        if (!(display instanceof Display.BlockDisplay)) {
            return;
        }
        Display.BlockDisplay blockDisplay = (Display.BlockDisplay)display;
        BlockState state = Helper.getBlockState(blockDisplay);
        this.properties.clear();
        state.getProperties().stream().filter(it -> !it.equals((Object)BlockStateProperties.WATERLOGGED)).forEach(this.properties::add);
    }

    private static <T extends Comparable<T>> BlockState apply(BlockState state, Property<T> property, Object value) {
        return (BlockState)state.trySetValue(property, (Comparable)value);
    }
}

