/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.widgets.EditorButton;
import dev.obscuria.displayedit.client.widgets.EnumButton;
import dev.obscuria.displayedit.client.widgets.LocationField;
import dev.obscuria.displayedit.network.ServerboundDisplayContextPayload;
import dev.obscuria.displayedit.network.ServerboundItemStackPayload;
import dev.obscuria.displayedit.platform.Services;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ItemStackSection
extends AbstractEditorSection {
    private static final Component NAME_LOAD_FROM_HAND = Component.translatable((String)"editor.section.item_stack.load_from_hand");
    @Nullable
    private String fieldName;
    @Nullable
    private ItemStack handStack;
    @Nullable
    private ItemDisplayContext transform;

    public ItemStackSection() {
        super(SectionType.ITEM_STACK);
    }

    @Override
    public void buildExpanded(EditorScreen screen, @Nullable Display display) {
        ItemDisplayContext itemDisplayContext;
        screen.add(new EditorButton(NAME_LOAD_FROM_HAND, this.x + 4, this.y + 18, 112, 14, this.active, this::loadFromHand));
        LocationField fieldName = screen.add(new LocationField(this.x + 7, this.y + 51, 106, 12, this.active));
        fieldName.setLocation(this.getItemName(display));
        fieldName.setResponder(this::fieldNameChanged);
        EnumButton<ItemDisplayContext> transform = screen.add(new EnumButton<ItemDisplayContext>(ItemDisplayContext.class, this.x + 6, this.y + 84, 108, 14, this.active, this::transformChanged));
        if (display instanceof Display.ItemDisplay) {
            Display.ItemDisplay itemDisplay = (Display.ItemDisplay)display;
            itemDisplayContext = Helper.getItemTransform(itemDisplay);
        } else {
            itemDisplayContext = ItemDisplayContext.NONE;
        }
        transform.setValue(itemDisplayContext);
    }

    @Override
    public void renderExpanded(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawPanel(graphics, "Name", this.x + 4, this.y + 33, 112, 33);
        this.drawPanel(graphics, "Transform", this.x + 4, this.y + 67, 112, 33);
    }

    @Override
    protected void apply(Display display) {
        if (!(display instanceof Display.ItemDisplay)) {
            return;
        }
        Display.ItemDisplay itemDisplay = (Display.ItemDisplay)display;
        if (this.maybeApplyByName(itemDisplay)) {
            return;
        }
        if (this.maybeApplyByHand(itemDisplay)) {
            return;
        }
        this.maybeApplyTransform(itemDisplay);
    }

    @Override
    protected int expandedHeight() {
        return 104;
    }

    @Override
    protected boolean isActive(@Nullable Display display) {
        return !this.locked && display instanceof Display.ItemDisplay;
    }

    private void loadFromHand(Button button) {
        this.handStack = Optional.ofNullable(Minecraft.getInstance().player).map(LivingEntity::getMainHandItem).orElse(null);
        this.markDirty();
        EditorScreen.apply();
    }

    private void fieldNameChanged(String name) {
        this.fieldName = name;
        this.markDirty();
    }

    private void transformChanged(ItemDisplayContext transform) {
        this.transform = transform;
        this.markDirty();
        EditorScreen.apply();
    }

    @Nullable
    private ResourceLocation getItemName(@Nullable Display display) {
        if (!(display instanceof Display.ItemDisplay)) {
            return null;
        }
        Display.ItemDisplay itemDisplay = (Display.ItemDisplay)display;
        return Helper.getItemStack(itemDisplay).getItem().builtInRegistryHolder().key().location();
    }

    private boolean maybeApplyByName(Display.ItemDisplay display) {
        ItemStack stack = this.parseItemStack();
        if (stack == null) {
            return false;
        }
        Helper.setItemStack(display, stack);
        Services.PLATFORM.sendToServer(ServerboundItemStackPayload.stack((Display)display, stack));
        return true;
    }

    private boolean maybeApplyByHand(Display.ItemDisplay display) {
        if (this.handStack == null || this.handStack.isEmpty()) {
            return false;
        }
        Helper.setItemStack(display, this.handStack);
        Services.PLATFORM.sendToServer(ServerboundItemStackPayload.stack((Display)display, this.handStack));
        return true;
    }

    private void maybeApplyTransform(Display.ItemDisplay display) {
        if (this.transform == null) {
            return;
        }
        Helper.setItemTransform(display, this.transform);
        Services.PLATFORM.sendToServer(ServerboundDisplayContextPayload.transform((Display)display, this.transform));
    }

    @Nullable
    private ItemStack parseItemStack() {
        if (this.fieldName == null) {
            return null;
        }
        try {
            ResourceLocation location = ResourceLocation.parse((String)this.fieldName);
            Holder.Reference item = (Holder.Reference)BuiltInRegistries.ITEM.get(location).orElseThrow();
            return ((Item)item.value()).getDefaultInstance();
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

