/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.widgets.EditorButton;
import dev.obscuria.displayedit.network.ServerboundCreatePayload;
import dev.obscuria.displayedit.network.ServerboundDeletePayload;
import dev.obscuria.displayedit.network.ServerboundLockPayload;
import dev.obscuria.displayedit.network.ServerboundPastePayload;
import dev.obscuria.displayedit.platform.Services;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Display;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class ManagerSection
extends AbstractEditorSection {
    private static final Component NAME_LOCK = Component.translatable((String)"editor.section.manager.lock");
    private static final Component NAME_UNLOCK = Component.translatable((String)"editor.section.manager.unlock");
    private static final Component NAME_DELETE = Component.translatable((String)"editor.section.manager.delete").withStyle(ChatFormatting.RED);
    private static final Component NAME_NEW_BLOCK = Component.translatable((String)"editor.section.manager.new_block");
    private static final Component NAME_NEW_ITEM = Component.translatable((String)"editor.section.manager.new_item");
    private static final Component NAME_NEW_TEXT = Component.translatable((String)"editor.section.manager.new_text");
    private static final Component NAME_DUPLICATE = Component.translatable((String)"editor.section.manager.duplicate");
    private static final Component NAME_COPY = Component.translatable((String)"editor.section.manager.copy");
    private static final Component NAME_PASTE = Component.translatable((String)"editor.section.manager.paste");
    private static final Component NAME_CLEAR = Component.literal((String)"x").withStyle(ChatFormatting.RED);
    @Nullable
    private static CompoundTag buffer;
    private static boolean bufferIsBlock;
    private boolean actionCycleLocked = false;
    private boolean actionDelete = false;

    public ManagerSection() {
        super(SectionType.MANAGER);
    }

    @Override
    public void buildExpanded(EditorScreen screen, @Nullable Display display) {
        screen.add(new EditorButton(this.locked ? NAME_UNLOCK : NAME_LOCK, this.x + 6, this.y + 35, 54, 14, display != null, this::cycleLocked));
        screen.add(new EditorButton(NAME_DELETE, this.x + 61, this.y + 35, 53, 14, display != null && !this.locked, this::delete));
        screen.add(new EditorButton(NAME_NEW_BLOCK, this.x + 6, this.y + 69, 108, 14, ManagerSection::newBlock));
        screen.add(new EditorButton(NAME_NEW_ITEM, this.x + 6, this.y + 84, 108, 14, ManagerSection::newItem));
        screen.add(new EditorButton(NAME_NEW_TEXT, this.x + 6, this.y + 99, 108, 14, ManagerSection::newText));
        screen.add(new EditorButton(NAME_DUPLICATE, this.x + 6, this.y + 133, 108, 14, display != null, ManagerSection::duplicate));
        screen.add(new EditorButton(NAME_COPY, this.x + 6, this.y + 148, 46, 14, display != null, ManagerSection::copy));
        screen.add(new EditorButton(NAME_PASTE, this.x + 53, this.y + 148, 46, 14, buffer != null, ManagerSection::paste));
        screen.add(new EditorButton(NAME_CLEAR, this.x + 100, this.y + 148, 14, 14, buffer != null, ManagerSection::clear));
    }

    @Override
    public void renderExpanded(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawPanel(graphics, "Display", this.x + 4, this.y + 18, 112, 33);
        this.drawPanel(graphics, "Builder", this.x + 4, this.y + 52, 112, 63);
        this.drawPanel(graphics, "Tools", this.x + 4, this.y + 116, 112, 48);
    }

    @Override
    protected void apply(Display display) {
        if (this.actionCycleLocked) {
            Helper.setLocked(display, !this.locked);
            Services.PLATFORM.sendToServer(ServerboundLockPayload.lock(display, !this.locked));
            this.actionCycleLocked = false;
        }
        if (this.actionDelete) {
            Services.PLATFORM.sendToServer(ServerboundDeletePayload.delete(display));
        }
    }

    @Override
    protected int expandedHeight() {
        return 168;
    }

    @Override
    protected boolean isActive(@Nullable Display display) {
        return true;
    }

    @Override
    protected Component displayName() {
        return this.locked ? Component.literal((String)"\ud83d\udd12 ").append(super.displayName()) : super.displayName();
    }

    private void cycleLocked(Button button) {
        this.actionCycleLocked = true;
        this.markDirty();
        EditorScreen.apply();
    }

    private void delete(Button button) {
        this.actionDelete = true;
        this.markDirty();
        EditorScreen.apply();
    }

    private static void newBlock(Button button) {
        Services.PLATFORM.sendToServer(ServerboundCreatePayload.newBlock());
    }

    private static void newItem(Button button) {
        Services.PLATFORM.sendToServer(ServerboundCreatePayload.newItem());
    }

    private static void newText(Button button) {
        Services.PLATFORM.sendToServer(ServerboundCreatePayload.newText());
    }

    private static void duplicate(Button button) {
        Display display = EditorScreen.getSelected();
        if (!(display instanceof Display)) {
            return;
        }
        Display display2 = display;
        Services.PLATFORM.sendToServer(ServerboundPastePayload.duplicate(display2));
    }

    private static void copy(Button button) {
        Display display = EditorScreen.getSelected();
        if (!(display instanceof Display)) {
            return;
        }
        Display display2 = display;
        bufferIsBlock = display2 instanceof Display.BlockDisplay;
        buffer = new CompoundTag();
        display2.save(buffer);
        EditorScreen.rebuild();
    }

    private static void paste(Button button) {
        if (buffer == null) {
            return;
        }
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        Vec3 position = bufferIsBlock ? new Vec3((Vec3i)player.blockPosition()) : player.blockPosition().getCenter();
        Services.PLATFORM.sendToServer(ServerboundPastePayload.paste(position, buffer));
    }

    private static void clear(Button button) {
        buffer = null;
        EditorScreen.rebuild();
    }

    static {
        bufferIsBlock = false;
    }
}

