/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.widgets.EnumButton;
import dev.obscuria.displayedit.network.ServerboundBillboardPayload;
import dev.obscuria.displayedit.network.ServerboundBrightnessPayload;
import dev.obscuria.displayedit.network.ServerboundViewRangePayload;
import dev.obscuria.displayedit.platform.Services;
import dev.obscuria.displayedit.world.FlagEnum;
import dev.obscuria.displayedit.world.LightLevel;
import dev.obscuria.displayedit.world.ViewRange;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import org.jetbrains.annotations.Nullable;

public final class PropertySection
extends AbstractEditorSection {
    @Nullable
    private Display.BillboardConstraints billboard;
    @Nullable
    private ViewRange viewRange;
    @Nullable
    private FlagEnum brightnessOverride;
    @Nullable
    private LightLevel brightnessBlock;
    @Nullable
    private LightLevel brightnessSky;

    public PropertySection() {
        super(SectionType.PROPERTIES);
    }

    @Override
    public void buildExpanded(EditorScreen screen, @Nullable Display display) {
        Display.BillboardConstraints billboardConstraints;
        EnumButton<Display.BillboardConstraints> billboard = screen.add(new EnumButton<Display.BillboardConstraints>(Display.BillboardConstraints.class, this.x + 64, this.y + 20, 50, 14, this.active, this::billboardChanged));
        if (display instanceof Display) {
            Display entity = display;
            billboardConstraints = Helper.getBillboardConstraints(entity);
        } else {
            billboardConstraints = Display.BillboardConstraints.FIXED;
        }
        billboard.setValue(billboardConstraints);
        EnumButton<ViewRange> viewRange = screen.add(new EnumButton<ViewRange>(ViewRange.class, this.x + 64, this.y + 35, 50, 14, this.active, this::viewRangeChanged));
        viewRange.setValue(ViewRange.closestTo(display));
        boolean hasOverride = display != null && Helper.getBrightnessOverride(display) != null;
        EnumButton<FlagEnum> brightnessOverride = screen.add(new EnumButton<FlagEnum>(FlagEnum.class, this.x + 62, this.y + 67, 50, 14, this.active, this::brightnessOverrideChanged));
        brightnessOverride.setValue(FlagEnum.valueOf(hasOverride));
        EnumButton<LightLevel> brightnessBlock = screen.add(new EnumButton<LightLevel>(LightLevel.class, this.x + 62, this.y + 82, 50, 14, this.active && hasOverride, this::brightnessBlockChanged));
        brightnessBlock.setValue(LightLevel.blockLightOf(display));
        EnumButton<LightLevel> brightnessSky = screen.add(new EnumButton<LightLevel>(LightLevel.class, this.x + 62, this.y + 97, 50, 14, this.active & hasOverride, this::brightnessSkyChanged));
        brightnessSky.setValue(LightLevel.skyLightOf(display));
    }

    @Override
    public void renderExpanded(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawPanel(graphics, "", this.x + 4, this.y + 18, 112, 97);
        this.drawPanel(graphics, "Brightness", this.x + 6, this.y + 50, 108, 63);
        graphics.drawString(Minecraft.getInstance().font, "billboard", this.x + 7, this.y + 24, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "view_range", this.x + 7, this.y + 38, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "override", this.x + 9, this.y + 70, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "block", this.x + 9, this.y + 85, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "sky", this.x + 9, this.y + 100, -1, true);
    }

    @Override
    protected void apply(Display display) {
        this.maybeApplyBillboard(display);
        this.maybeApplyViewRange(display);
        this.maybeApplyBrightness(display);
    }

    @Override
    protected int expandedHeight() {
        return 119;
    }

    @Override
    protected boolean isActive(@Nullable Display display) {
        return display != null && !this.locked;
    }

    private void billboardChanged(Display.BillboardConstraints billboard) {
        this.billboard = billboard;
        this.markDirty();
        EditorScreen.apply();
    }

    private void viewRangeChanged(ViewRange range) {
        this.viewRange = range;
        this.markDirty();
        EditorScreen.apply();
    }

    private void brightnessOverrideChanged(FlagEnum flag) {
        this.brightnessOverride = flag;
        this.markDirty();
        EditorScreen.apply();
    }

    private void brightnessBlockChanged(LightLevel level) {
        this.brightnessBlock = level;
        this.markDirty();
        EditorScreen.apply();
    }

    private void brightnessSkyChanged(LightLevel level) {
        this.brightnessSky = level;
        this.markDirty();
        EditorScreen.apply();
    }

    private void maybeApplyBillboard(Display display) {
        if (this.billboard == null) {
            return;
        }
        Helper.setBillboardConstraints(display, this.billboard);
        Services.PLATFORM.sendToServer(ServerboundBillboardPayload.billboard(display, this.billboard));
    }

    private void maybeApplyViewRange(Display display) {
        if (this.viewRange == null) {
            return;
        }
        Helper.setViewRange(display, this.viewRange.value);
        Services.PLATFORM.sendToServer(ServerboundViewRangePayload.viewRange(display, this.viewRange));
    }

    private void maybeApplyBrightness(Display display) {
        int block;
        if (this.brightnessOverride != null) {
            Helper.setBrightnessOverride(display, this.brightnessOverride.value ? new Brightness(15, 15) : null);
            Services.PLATFORM.sendToServer(ServerboundBrightnessPayload.override(display, this.brightnessOverride));
            return;
        }
        if (this.brightnessBlock == null && this.brightnessSky == null) {
            return;
        }
        Brightness current = Helper.getBrightnessOverride(display);
        int n = this.brightnessBlock != null ? this.brightnessBlock.value : (block = current != null ? current.block() : 0);
        int sky = this.brightnessSky != null ? this.brightnessSky.value : (current != null ? current.sky() : 0);
        Brightness brightness = new Brightness(block, sky);
        Helper.setBrightnessOverride(display, brightness);
        Services.PLATFORM.sendToServer(ServerboundBrightnessPayload.brightness(display, brightness));
    }
}

