/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.sections;

import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.client.EditorScreen;
import dev.obscuria.displayedit.client.SectionType;
import dev.obscuria.displayedit.client.sections.AbstractEditorSection;
import dev.obscuria.displayedit.client.widgets.Checkbox;
import dev.obscuria.displayedit.client.widgets.EnumButton;
import dev.obscuria.displayedit.client.widgets.TextField;
import dev.obscuria.displayedit.network.ServerboundBackgroundColorPayload;
import dev.obscuria.displayedit.network.ServerboundFlagsPayload;
import dev.obscuria.displayedit.network.ServerboundLineWidthPayload;
import dev.obscuria.displayedit.network.ServerboundOpacityPayload;
import dev.obscuria.displayedit.network.ServerboundTextPayload;
import dev.obscuria.displayedit.platform.Services;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Display;
import org.jetbrains.annotations.Nullable;

public final class TextSection
extends AbstractEditorSection {
    @Nullable
    private String fieldText;
    @Nullable
    private String fieldBackground;
    @Nullable
    private Display.TextDisplay.Align alignment;
    @Nullable
    private Boolean defaultBackground;
    @Nullable
    private Boolean seeThrough;
    @Nullable
    private Boolean shadow;
    @Nullable
    private String fieldLineWidth;
    @Nullable
    private String fieldOpacity;

    public TextSection() {
        super(SectionType.TEXT);
    }

    @Override
    public void buildExpanded(EditorScreen screen, @Nullable Display display) {
        Display.TextDisplay textDisplay;
        Display.TextDisplay textDisplay2;
        Display.TextDisplay textDisplay3;
        Display.TextDisplay.Align align;
        TextField fieldText = screen.add(new TextField(this.x + 7, this.y + 36, 106, 12, this.active));
        fieldText.setValue(TextSection.textOf(display));
        fieldText.setResponder(this::fieldTextChanged);
        TextField fieldBackground = screen.add(new TextField(this.x + 7, this.y + 70, 106, 12, this.active));
        fieldBackground.setValue(TextSection.backgroundOf(display));
        fieldBackground.setResponder(this::fieldBackgroundChanged);
        EnumButton<Display.TextDisplay.Align> alignment = screen.add(new EnumButton<Display.TextDisplay.Align>(Display.TextDisplay.Align.class, this.x + 64, this.y + 88, 50, 14, this.active, this::alignmentChanged));
        if (display instanceof Display.TextDisplay) {
            Display.TextDisplay textDisplay4 = (Display.TextDisplay)display;
            align = Helper.getAlign(textDisplay4);
        } else {
            align = Display.TextDisplay.Align.CENTER;
        }
        alignment.setValue(align);
        Checkbox defaultBackground = screen.add(new Checkbox(this.x + 100, this.y + 103, this.active, this::defaultBackgroundChanged));
        defaultBackground.setEnabled(display instanceof Display.TextDisplay && Helper.hasDefaultBackground(textDisplay3 = (Display.TextDisplay)display));
        Checkbox seeThrough = screen.add(new Checkbox(this.x + 100, this.y + 118, this.active, this::seeThroughChanged));
        seeThrough.setEnabled(display instanceof Display.TextDisplay && Helper.hasSeeThrough(textDisplay2 = (Display.TextDisplay)display));
        Checkbox shadow = screen.add(new Checkbox(this.x + 100, this.y + 133, this.active, this::shadowChanged));
        shadow.setEnabled(display instanceof Display.TextDisplay && Helper.hasShadow(textDisplay = (Display.TextDisplay)display));
        TextField fieldLineWidth = screen.add(new TextField(this.x + 65, this.y + 149, 48, 12, this.active));
        fieldLineWidth.setValue(TextSection.lineWidthOf(display));
        fieldLineWidth.setResponder(this::fieldLineWidthChanged);
        TextField fieldOpacity = screen.add(new TextField(this.x + 65, this.y + 164, 48, 12, this.active));
        fieldOpacity.setValue(TextSection.opacityOf(display));
        fieldOpacity.setResponder(this::fieldOpacityChanged);
    }

    @Override
    public void renderExpanded(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawPanel(graphics, "Raw JSON", this.x + 4, this.y + 18, 112, 33);
        this.drawPanel(graphics, "Background ARGB", this.x + 4, this.y + 52, 112, 33);
        this.drawPanel(graphics, "", this.x + 4, this.y + 86, 112, 93);
        graphics.drawString(Minecraft.getInstance().font, "alignment", this.x + 7, this.y + 91, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "default_back", this.x + 7, this.y + 106, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "see_thought", this.x + 7, this.y + 121, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "shadow", this.x + 7, this.y + 136, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "line_width", this.x + 7, this.y + 151, -1, true);
        graphics.drawString(Minecraft.getInstance().font, "opacity", this.x + 7, this.y + 166, -1, true);
    }

    @Override
    protected void apply(Display display) {
        if (!(display instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay textDisplay = (Display.TextDisplay)display;
        this.maybeApplyText(textDisplay);
        this.maybeApplyBackgroundColor(textDisplay);
        this.maybeApplyFlags(textDisplay);
        this.maybeApplyLineWidth(textDisplay);
        this.maybeApplyOpacity(textDisplay);
    }

    @Override
    protected int expandedHeight() {
        return 183;
    }

    @Override
    protected boolean isActive(@Nullable Display display) {
        return !this.locked && display instanceof Display.TextDisplay;
    }

    private void fieldTextChanged(String value) {
        this.fieldText = value;
        this.markDirty();
    }

    private void fieldBackgroundChanged(String value) {
        this.fieldBackground = value;
        this.markDirty();
    }

    private void alignmentChanged(Display.TextDisplay.Align alignment) {
        this.alignment = alignment;
        this.markDirty();
        EditorScreen.apply();
    }

    private void defaultBackgroundChanged(boolean value) {
        this.defaultBackground = value;
        this.markDirty();
        EditorScreen.apply();
    }

    private void seeThroughChanged(boolean value) {
        this.seeThrough = value;
        this.markDirty();
        EditorScreen.apply();
    }

    private void shadowChanged(boolean value) {
        this.shadow = value;
        this.markDirty();
        EditorScreen.apply();
    }

    private void fieldLineWidthChanged(String value) {
        this.fieldLineWidth = value;
        this.markDirty();
    }

    private void fieldOpacityChanged(String value) {
        this.fieldOpacity = value;
        this.markDirty();
    }

    private void maybeApplyText(Display.TextDisplay display) {
        if (this.fieldText == null) {
            return;
        }
        try {
            RegistryAccess registries = Objects.requireNonNull(Minecraft.getInstance().level).registryAccess();
            MutableComponent text = Component.Serializer.fromJson((String)this.fieldText, (HolderLookup.Provider)registries);
            if (text == null) {
                return;
            }
            Helper.setText(display, (Component)text);
            Services.PLATFORM.sendToServer(ServerboundTextPayload.text((Display)display, (Component)text));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void maybeApplyBackgroundColor(Display.TextDisplay display) {
        if (this.fieldBackground == null) {
            return;
        }
        try {
            int color = (int)Long.parseLong(this.fieldBackground.replaceFirst("#", ""), 16);
            Helper.setBackgroundColor(display, color);
            Services.PLATFORM.sendToServer(ServerboundBackgroundColorPayload.color((Display)display, color));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void maybeApplyFlags(Display.TextDisplay display) {
        if (this.alignment != null) {
            Helper.setAlign(display, this.alignment);
            Services.PLATFORM.sendToServer(ServerboundFlagsPayload.alignment((Display)display, this.alignment));
        }
        if (this.defaultBackground != null) {
            Helper.setDefaultBackground(display, this.defaultBackground);
            Services.PLATFORM.sendToServer(ServerboundFlagsPayload.defaultBackground((Display)display, this.defaultBackground));
        }
        if (this.seeThrough != null) {
            Helper.setSeeThrough(display, this.seeThrough);
            Services.PLATFORM.sendToServer(ServerboundFlagsPayload.seeThrough((Display)display, this.seeThrough));
        }
        if (this.shadow != null) {
            Helper.setShadow(display, this.shadow);
            Services.PLATFORM.sendToServer(ServerboundFlagsPayload.shadow((Display)display, this.shadow));
        }
    }

    private void maybeApplyLineWidth(Display.TextDisplay display) {
        if (this.fieldLineWidth == null) {
            return;
        }
        try {
            int lineWidth = Integer.parseInt(this.fieldLineWidth);
            Helper.setLineWidth(display, lineWidth);
            Services.PLATFORM.sendToServer(ServerboundLineWidthPayload.lineWidth((Display)display, lineWidth));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void maybeApplyOpacity(Display.TextDisplay display) {
        if (this.fieldOpacity == null) {
            return;
        }
        try {
            byte opacity = Byte.parseByte(this.fieldOpacity);
            Helper.setTextOpacity(display, opacity);
            Services.PLATFORM.sendToServer(ServerboundOpacityPayload.opacity((Display)display, opacity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String textOf(@Nullable Display display) {
        if (!(display instanceof Display.TextDisplay)) {
            return "empty";
        }
        Display.TextDisplay textDisplay = (Display.TextDisplay)display;
        RegistryAccess registries = Objects.requireNonNull(Minecraft.getInstance().level).registryAccess();
        return Component.Serializer.toJson((Component)Helper.getText(textDisplay), (HolderLookup.Provider)registries);
    }

    private static String backgroundOf(@Nullable Display display) {
        if (!(display instanceof Display.TextDisplay)) {
            return "#ffffffff";
        }
        Display.TextDisplay textDisplay = (Display.TextDisplay)display;
        return String.format("#%08X", Helper.getBackgroundColor(textDisplay));
    }

    private static String lineWidthOf(@Nullable Display display) {
        if (!(display instanceof Display.TextDisplay)) {
            return "0";
        }
        Display.TextDisplay textDisplay = (Display.TextDisplay)display;
        return Integer.toString(Helper.getLineWidth(textDisplay));
    }

    private static String opacityOf(@Nullable Display display) {
        if (!(display instanceof Display.TextDisplay)) {
            return "0";
        }
        Display.TextDisplay textDisplay = (Display.TextDisplay)display;
        return Byte.toString(Helper.getTextOpacity(textDisplay));
    }
}

