/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.widgets;

import dev.obscuria.displayedit.DisplayEdit;
import dev.obscuria.displayedit.client.Brush;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BrushButton
extends ImageButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(DisplayEdit.key("textures/gui/sprites/widget/brush.png"), DisplayEdit.key("textures/gui/sprites/widget/brush_disabled.png"), DisplayEdit.key("textures/gui/sprites/widget/brush_highlighted.png"), DisplayEdit.key("textures/gui/sprites/widget/brush_disabled.png"));
    private final Brush brush;

    public BrushButton(Brush brush, int x, int y) {
        super(x, y, 12, 12, SPRITES, self -> ((BrushButton)self).cycle());
        this.brush = brush;
        this.updateTooltip();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        ResourceLocation sprite = this.sprites.get(this.isActive(), this.isHoveredOrFocused());
        graphics.blit(RenderType::guiTextured, sprite, this.getX(), this.getY(), (float)(this.width * this.brush.size()), 0.0f, this.width, this.height, this.width * 4, this.height);
    }

    private void cycle() {
        this.brush.cycle();
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.setTooltip(Tooltip.create((Component)this.brush.name()));
    }
}

