/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class EditorButton
extends Button {
    public EditorButton(Component name, int x, int y, int width, int height, Button.OnPress action) {
        this(name, x, y, width, height, true, action);
    }

    public EditorButton(Component name, int x, int y, int width, int height, boolean active, Button.OnPress action) {
        super(x, y, width, height, name, action, Button.DEFAULT_NARRATION);
        this.active = active;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int outlineColor;
        int mainColor;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int n = mainColor = this.active ? -12566464 : -14671840;
        int n2 = this.active ? (this.isHovered() || this.isFocused() ? -1 : -10461088) : (outlineColor = -13619152);
        int topColor = this.active ? (this.isHovered() || this.isFocused() ? -1 : -8355712) : -12566464;
        context.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), mainColor);
        context.renderOutline(this.getX(), this.getY(), this.getWidth(), this.getHeight(), outlineColor);
        context.hLine(this.getX(), this.getX() + this.getWidth() - 1, this.getY(), topColor);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderString(context, Minecraft.getInstance().font, this.active ? -1 : -8355712);
    }

    public static class Decrement
    extends EditorButton {
        public Decrement(int x, int y, boolean active, Runnable action) {
            super((Component)Component.literal((String)"-"), x, y, 14, 14, active, self -> action.run());
        }
    }

    public static class Increment
    extends EditorButton {
        public Increment(int x, int y, boolean active, Runnable action) {
            super((Component)Component.literal((String)"+"), x, y, 14, 14, active, self -> action.run());
        }
    }
}

