/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.widgets;

import dev.obscuria.displayedit.client.widgets.EditorButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class EnumButton<T extends Enum<T>>
extends EditorButton {
    private final Consumer<T> listener;
    private final List<T> values;
    private int index;

    public EnumButton(Class<T> type, int x, int y, int width, int height, boolean active, Consumer<T> listener) {
        super(CommonComponents.EMPTY, x, y, width, height, active, self -> ((EnumButton)self).cycle());
        this.values = List.of((Enum[])type.getEnumConstants());
        this.listener = listener;
    }

    public void setValue(T value) {
        this.index = this.values.indexOf(value);
        this.update();
    }

    private void cycle() {
        this.index = (this.index + 1) % this.values.size();
        this.listener.accept((Enum)this.values.get(this.index));
        this.update();
    }

    private void update() {
        this.setMessage((Component)Component.literal((String)((Enum)this.values.get(this.index)).toString().toLowerCase()));
    }
}

