/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.client.widgets;

import dev.obscuria.displayedit.client.widgets.EditorButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.properties.Property;

public class PropertyButton
extends EditorButton {
    public final Property<?> property;
    private final List<? extends Property.Value<?>> values;
    private final List<?> rawValues;
    private final Consumer<Property.Value<?>> listener;
    private int index;

    public PropertyButton(Property<?> property, int x, int y, int width, int height, boolean active, Consumer<Property.Value<?>> listener) {
        super(CommonComponents.EMPTY, x, y, width, height, active, self -> ((PropertyButton)self).cycle());
        this.listener = listener;
        this.property = property;
        this.values = property.getAllValues().toList();
        this.rawValues = this.values.stream().map(Property.Value::value).toList();
    }

    public void setValue(Object raw) {
        this.index = this.rawValues.indexOf(raw);
        this.update();
    }

    private void cycle() {
        this.index = (this.index + 1) % this.values.size();
        this.listener.accept(this.values.get(this.index));
        this.update();
    }

    private void update() {
        this.setMessage((Component)Component.literal((String)this.rawValues.get(this.index).toString().toLowerCase()));
    }
}

