/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.network;

import dev.obscuria.displayedit.Helper;
import dev.obscuria.displayedit.network.ClientboundSelectPayload;
import dev.obscuria.displayedit.network.ServerboundBackgroundColorPayload;
import dev.obscuria.displayedit.network.ServerboundBillboardPayload;
import dev.obscuria.displayedit.network.ServerboundBlockStatePayload;
import dev.obscuria.displayedit.network.ServerboundBrightnessPayload;
import dev.obscuria.displayedit.network.ServerboundCreatePayload;
import dev.obscuria.displayedit.network.ServerboundDeletePayload;
import dev.obscuria.displayedit.network.ServerboundDisplayContextPayload;
import dev.obscuria.displayedit.network.ServerboundFlagsPayload;
import dev.obscuria.displayedit.network.ServerboundItemStackPayload;
import dev.obscuria.displayedit.network.ServerboundLineWidthPayload;
import dev.obscuria.displayedit.network.ServerboundLockPayload;
import dev.obscuria.displayedit.network.ServerboundOpacityPayload;
import dev.obscuria.displayedit.network.ServerboundPastePayload;
import dev.obscuria.displayedit.network.ServerboundTextPayload;
import dev.obscuria.displayedit.network.ServerboundTransformPayload;
import dev.obscuria.displayedit.network.ServerboundViewRangePayload;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class ServerPayloadHandler {
    public static void handle(ServerboundCreatePayload payload, ServerPlayer player, Consumer<CustomPacketPayload> response) {
        Display display;
        switch (payload.operation()) {
            case 0: {
                Display display2 = ServerPayloadHandler.createBlock(player);
                break;
            }
            case 1: {
                Display display2 = ServerPayloadHandler.createItem(player);
                break;
            }
            case 2: {
                Display display2 = ServerPayloadHandler.createText(player);
                break;
            }
            default: {
                Display display2 = display = null;
            }
        }
        if (display == null) {
            return;
        }
        response.accept(ClientboundSelectPayload.select(display));
    }

    public static void handle(ServerboundPastePayload payload, ServerPlayer player, Consumer<CustomPacketPayload> response) {
        EntityType.by((CompoundTag)payload.tag()).ifPresent(type -> {
            Entity entity = type.create(player.level(), EntitySpawnReason.COMMAND);
            if (!(entity instanceof Display)) {
                return;
            }
            Display display = (Display)entity;
            display.load(payload.tag());
            display.setUUID(UUID.randomUUID());
            display.setPos(payload.position());
            player.level().addFreshEntity((Entity)display);
            response.accept(ClientboundSelectPayload.select(display));
        });
    }

    public static void handle(ServerboundTransformPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display)) {
            return;
        }
        Display display = (Display)entity;
        payload.position().ifPresent(arg_0 -> ((Display)display).setPos(arg_0));
        payload.translation().ifPresent(value -> Helper.setTranslation(display, value));
        payload.scale().ifPresent(value -> Helper.setScale(display, value));
        payload.leftRotation().ifPresent(value -> Helper.setLeftRotation(display, value));
        payload.rightRotation().ifPresent(value -> Helper.setRightRotation(display, value));
    }

    public static void handle(ServerboundDeletePayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display)) {
            return;
        }
        Display display = (Display)entity;
        display.discard();
    }

    public static void handle(ServerboundLockPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display)) {
            return;
        }
        Display display = (Display)entity;
        Helper.setLocked(display, payload.locked());
    }

    public static void handle(ServerboundBlockStatePayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.BlockDisplay)) {
            return;
        }
        Display.BlockDisplay display = (Display.BlockDisplay)entity;
        Helper.setBlockState(display, payload.state());
    }

    public static void handle(ServerboundItemStackPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.ItemDisplay)) {
            return;
        }
        Display.ItemDisplay display = (Display.ItemDisplay)entity;
        Helper.setItemStack(display, payload.stack());
    }

    public static void handle(ServerboundDisplayContextPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.ItemDisplay)) {
            return;
        }
        Display.ItemDisplay display = (Display.ItemDisplay)entity;
        Helper.setItemTransform(display, payload.transform());
    }

    public static void handle(ServerboundBillboardPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display)) {
            return;
        }
        Display display = (Display)entity;
        Helper.setBillboardConstraints(display, payload.billboard());
    }

    public static void handle(ServerboundViewRangePayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display)) {
            return;
        }
        Display display = (Display)entity;
        Helper.setViewRange(display, payload.viewRange().value);
    }

    public static void handle(ServerboundBrightnessPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display)) {
            return;
        }
        Display display = (Display)entity;
        payload.override().ifPresent(value -> Helper.setBrightnessOverride(display, value.value ? new Brightness(15, 15) : null));
        payload.brightness().ifPresent(value -> Helper.setBrightnessOverride(display, value));
    }

    public static void handle(ServerboundTextPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay display = (Display.TextDisplay)entity;
        Helper.setText(display, payload.text());
    }

    public static void handle(ServerboundFlagsPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay display = (Display.TextDisplay)entity;
        payload.alignment().ifPresent(value -> Helper.setAlign(display, value));
        payload.defaultBackground().ifPresent(value -> Helper.setDefaultBackground(display, value));
        payload.seeThrough().ifPresent(value -> Helper.setSeeThrough(display, value));
        payload.shadow().ifPresent(value -> Helper.setShadow(display, value));
    }

    public static void handle(ServerboundBackgroundColorPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay display = (Display.TextDisplay)entity;
        Helper.setBackgroundColor(display, payload.color());
    }

    public static void handle(ServerboundLineWidthPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay display = (Display.TextDisplay)entity;
        Helper.setLineWidth(display, payload.width());
    }

    public static void handle(ServerboundOpacityPayload payload, ServerPlayer player) {
        Entity entity = player.level().getEntity(payload.entityId());
        if (!(entity instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay display = (Display.TextDisplay)entity;
        Helper.setTextOpacity(display, payload.opacity());
    }

    @Nullable
    private static Display createBlock(ServerPlayer player) {
        Display.BlockDisplay display = (Display.BlockDisplay)EntityType.BLOCK_DISPLAY.create(player.level(), EntitySpawnReason.COMMAND);
        if (display == null) {
            return null;
        }
        display.setPos(new Vec3((Vec3i)player.blockPosition()));
        Helper.setBlockState(display, Blocks.ORANGE_WOOL.defaultBlockState());
        player.level().addFreshEntity((Entity)display);
        return display;
    }

    @Nullable
    private static Display createItem(ServerPlayer player) {
        Display.ItemDisplay display = (Display.ItemDisplay)EntityType.ITEM_DISPLAY.create(player.level(), EntitySpawnReason.COMMAND);
        if (display == null) {
            return null;
        }
        display.setPos(player.blockPosition().getCenter());
        Helper.setItemStack(display, Items.FOX_SPAWN_EGG.getDefaultInstance());
        player.level().addFreshEntity((Entity)display);
        return display;
    }

    @Nullable
    private static Display createText(ServerPlayer player) {
        Display.TextDisplay display = (Display.TextDisplay)EntityType.TEXT_DISPLAY.create(player.level(), EntitySpawnReason.COMMAND);
        if (display == null) {
            return null;
        }
        display.setPos(player.blockPosition().getCenter());
        Helper.setText(display, (Component)Component.literal((String)"Display Edit").withStyle(ChatFormatting.GOLD));
        Helper.setBillboardConstraints((Display)display, Display.BillboardConstraints.CENTER);
        player.level().addFreshEntity((Entity)display);
        return display;
    }
}

