/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.world;

import com.mojang.serialization.Codec;
import dev.obscuria.displayedit.Helper;
import net.minecraft.util.Brightness;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Display;
import org.jetbrains.annotations.Nullable;

public enum LightLevel implements StringRepresentable
{
    LEVEL_0("0", 0),
    LEVEL_1("1", 1),
    LEVEL_2("2", 2),
    LEVEL_3("3", 3),
    LEVEL_4("4", 4),
    LEVEL_5("5", 5),
    LEVEL_6("6", 6),
    LEVEL_7("7", 7),
    LEVEL_8("8", 8),
    LEVEL_9("9", 9),
    LEVEL_10("10", 10),
    LEVEL_11("11", 11),
    LEVEL_12("12", 12),
    LEVEL_13("13", 13),
    LEVEL_14("14", 14),
    LEVEL_15("15", 15);

    public static final Codec<LightLevel> CODEC;
    public final String displayName;
    public final int value;

    public static LightLevel blockLightOf(@Nullable Display display) {
        if (display == null) {
            return LEVEL_0;
        }
        Brightness override = Helper.getBrightnessOverride(display);
        return override == null ? LEVEL_0 : LightLevel.values()[override.block()];
    }

    public static LightLevel skyLightOf(@Nullable Display display) {
        if (display == null) {
            return LEVEL_0;
        }
        Brightness override = Helper.getBrightnessOverride(display);
        return override == null ? LEVEL_0 : LightLevel.values()[override.sky()];
    }

    private LightLevel(String displayName, int value) {
        this.displayName = displayName;
        this.value = value;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.displayName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(LightLevel::values);
    }
}

