/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.displayedit.world;

import com.mojang.serialization.Codec;
import dev.obscuria.displayedit.Helper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Display;
import org.jetbrains.annotations.Nullable;

public enum ViewRange implements StringRepresentable
{
    BLOCK_16("16", 0.25f),
    BLOCK_32("32", 0.5f),
    DEFAULT("64 (default)", 1.0f),
    BLOCK_128("128", 2.0f),
    BLOCK_256("256", 4.0f),
    BLOCK_512("512", 8.0f),
    BLOCK_1024("1024", 16.0f);

    public static final Codec<ViewRange> CODEC;
    public final float value;
    public final String displayName;

    public static ViewRange closestTo(@Nullable Display display) {
        if (display == null) {
            return DEFAULT;
        }
        float displayViewRange = Helper.getViewRange(display);
        ViewRange closest = DEFAULT;
        float bestDiff = Float.MAX_VALUE;
        for (ViewRange range : ViewRange.values()) {
            float diff = Math.abs(range.value - displayViewRange);
            if (diff >= bestDiff) continue;
            bestDiff = diff;
            closest = range;
        }
        return closest;
    }

    private ViewRange(String displayName, float value) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.displayName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ViewRange::values);
    }
}

