/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.spookyjams_common_neoforge.registry.item.base;

import com.mojang.datafixers.util.Pair;
import com.natamus.spookyjams_common_neoforge.config.ConfigHandler;
import com.natamus.spookyjams_common_neoforge.items.SpookyJamsItems;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class JamItem
extends Item {
    public static FoodProperties foodProperties = new FoodProperties.Builder().nutrition(1).saturationModifier(1.0f).alwaysEdible().build();

    public JamItem(Item.Properties properties) {
        super(properties);
    }

    protected List<Pair<Holder<MobEffect>, Integer>> getConsumeEffects() {
        return List.of();
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResult.CONSUME;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        FoodProperties props;
        List<Pair<Holder<MobEffect>, Integer>> consumeEffects;
        if (!level.isClientSide() && !(consumeEffects = this.getConsumeEffects()).isEmpty()) {
            for (Pair<Holder<MobEffect>, Integer> mobEffectPair : consumeEffects) {
                entity.addEffect(new MobEffectInstance((Holder)mobEffectPair.getFirst(), (int)((double)((Integer)mobEffectPair.getSecond()).intValue() * ConfigHandler.jamConsumeEffectsModifier)));
            }
        }
        if ((props = foodProperties) != null && entity instanceof Player) {
            player = (Player)entity;
            if (!level.isClientSide()) {
                player.getFoodData().eat(props.nutrition(), props.saturation());
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
        if (!level.isClientSide()) {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (Holder)SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.gameEvent((Holder)GameEvent.EAT);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    return new ItemStack((ItemLike)SpookyJamsItems.GLASS_JAR);
                }
                player.getInventory().add(new ItemStack((ItemLike)SpookyJamsItems.GLASS_JAR));
            }
        }
        return stack;
    }
}

