/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.spookyjams_common_neoforge.registry.block;

import com.natamus.spookyjams_common_neoforge.items.SpookyJamsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SpookyYamCropBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final float AABB_OFFSET = 3.0f;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)};
    private static final int BONEMEAL_INCREASE = 1;

    public SpookyYamCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(new Property[]{AGE});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    @NotNull
    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return SpookyJamsItems.SPOOKY_YAM_SEEDS;
    }

    @NotNull
    public BlockState getStateForAge(int age) {
        return super.getStateForAge(age);
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource rand) {
        if (rand.nextInt(3) != 0) {
            super.randomTick(state, level, pos, rand);
        }
    }

    protected int getBonemealAgeIncrease(@NotNull Level level) {
        return 1;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        float matureBonus;
        if (!level.isClientSide) {
            return;
        }
        int age = this.getAge(state);
        if (age <= 0) {
            return;
        }
        float baseChance = 0.2f;
        float f = matureBonus = age == 3 ? 0.2f : 0.0f;
        if (rand.nextFloat() > baseChance + matureBonus) {
            return;
        }
        double height = switch (age) {
            case 1 -> 0.375;
            case 2 -> 0.5625;
            case 3 -> 0.8125;
            default -> 0.1875;
        };
        double x = (double)pos.getX() + 0.25 + rand.nextDouble() * 0.5;
        double z = (double)pos.getZ() + 0.25 + rand.nextDouble() * 0.5;
        double y = (double)pos.getY() + height * (0.7 + rand.nextDouble() * 0.3);
        float r = 0.3764706f;
        float g = 0.47058824f;
        float b = 0.8235294f;
        float scale = 0.35f;
        double vx = 0.0;
        double vy = 0.0025 + rand.nextDouble() * 0.0035;
        double vz = 0.0;
        level.addParticle((ParticleOptions)new DustColorTransitionOptions(new Vector3f(r, g, b), new Vector3f(Math.min(1.0f, r + 0.1f), Math.min(1.0f, g + 0.12f), Math.min(1.0f, b + 0.06f)), scale), x, y, z, vx, vy, vz);
    }

    private static double getVisualHeightForAge(int age) {
        return switch (age) {
            case 1 -> 0.375;
            case 2 -> 0.5625;
            case 3 -> 0.8125;
            default -> 0.1875;
        };
    }
}

