/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.spookyjams_common_neoforge.registry.item.base;

import com.mojang.datafixers.util.Pair;
import com.natamus.spookyjams_common_neoforge.config.ConfigHandler;
import com.natamus.spookyjams_common_neoforge.items.SpookyJamsItems;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class JamItem
extends Item {
    public static FoodProperties foodProperties = new FoodProperties.Builder().nutrition(1).saturationModifier(1.0f).alwaysEdible().build();

    public JamItem(Item.Properties properties) {
        super(properties);
    }

    protected List<Pair<Holder<MobEffect>, Integer>> getConsumeEffects() {
        return List.of();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            List<Pair<Holder<MobEffect>, Integer>> consumeEffects = this.getConsumeEffects();
            if (!consumeEffects.isEmpty()) {
                for (Pair<Holder<MobEffect>, Integer> mobEffectPair : consumeEffects) {
                    livingEntity.addEffect(new MobEffectInstance((Holder)mobEffectPair.getFirst(), (int)((double)((Integer)mobEffectPair.getSecond()).intValue() * ConfigHandler.jamConsumeEffectsModifier)));
                }
            }
            if (!player.getAbilities().instabuild) {
                if (itemStack.isEmpty()) {
                    return new ItemStack((ItemLike)SpookyJamsItems.GLASS_JAR);
                }
                player.getInventory().add(new ItemStack((ItemLike)SpookyJamsItems.GLASS_JAR));
            }
        }
        return livingEntity.eat(level, itemStack);
    }
}

